/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OTGWorldProvider
extends WorldProviderSurface {
    private DimensionConfig dimConfig = null;
    private WorldConfig worldConfig = null;
    private String worldName = null;
    private DimensionType dimType = null;
    private long lastFetchTime = 0L;
    public boolean isSPServerOverworld = false;

    protected void func_76572_b() {
        this.field_191067_f = true;
        if (!this.isSPServerOverworld) {
            this.field_76578_c = OTGPlugin.OtgWorldType.getBiomeProvider(this.field_76579_a);
        }
    }

    public void init(BiomeProvider biomeProvider) {
        this.field_191067_f = true;
        this.field_76578_c = biomeProvider;
    }

    public IChunkGenerator func_186060_c() {
        return OTGPlugin.OtgWorldType.getChunkGenerator(this.field_76579_a, "OpenTerrainGenerator");
    }

    public DimensionType func_186058_p() {
        if (this.dimType == null) {
            this.dimType = DimensionManager.getProviderType((int)this.field_76579_a.field_73011_w.getDimension());
        }
        return this.dimType;
    }

    public WorldConfig getWorldConfig() {
        ForgeWorld forgeWorld;
        if (this.worldConfig == null && (forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(this.field_76579_a)) != null) {
            this.worldConfig = forgeWorld.getConfigs().getWorldConfig();
        }
        return this.worldConfig;
    }

    public DimensionConfig getDimensionConfig() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFetchTime > 1000L) {
            DimensionsConfig dimsConfig;
            ForgeWorld forgeWorld;
            this.lastFetchTime = currentTime;
            if (this.worldName == null && (forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(this.field_76579_a)) != null) {
                this.worldName = forgeWorld.getName();
            }
            if (this.worldName != null && (dimsConfig = OTG.getDimensionsConfig()) != null) {
                this.dimConfig = dimsConfig.getDimensionConfig(this.worldName);
            }
        }
        return this.dimConfig;
    }

    public String getWelcomeMessage() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.WelcomeMessage : WorldStandardValues.WelcomeMessage.getDefaultValue();
    }

    public String getDepartMessage() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.DepartMessage : WorldStandardValues.DepartMessage.getDefaultValue();
    }

    public boolean func_76569_d() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.IsSurfaceWorld : WorldStandardValues.IsSurfaceWorld.getDefaultValue();
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos blockpos = new BlockPos(x, 0, z);
        if (this.field_76579_a.func_180494_b(blockpos).func_185352_i()) {
            return true;
        }
        ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(this.field_76579_a);
        return forgeWorld.getBlockAboveSolidHeight(x, z, null) != -1;
    }

    public BlockPos getRandomizedSpawnPoint() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        if (dimConfig != null && dimConfig.Settings.SpawnPointSet) {
            int randX = 0;
            int randZ = 0;
            if (dimConfig.GameRules.SpawnRadius != 0) {
                Random rand = new Random();
                randX = -dimConfig.GameRules.SpawnRadius + rand.nextInt(dimConfig.GameRules.SpawnRadius * 2);
                int maxZ = (int)Math.floor(Math.sqrt(dimConfig.GameRules.SpawnRadius * dimConfig.GameRules.SpawnRadius - randX * randX));
                randZ = maxZ == 0 ? 0 : -maxZ + rand.nextInt(maxZ * 2);
            }
            int SpawnPosX = this.field_76579_a.func_72912_H().func_76079_c() + randX;
            int SpawnPosZ = this.field_76579_a.func_72912_H().func_76074_e() + randZ;
            BlockPos SpawnPos = new BlockPos(SpawnPosX, 0, SpawnPosZ);
            BlockPos SpawnPosNew = this.field_76579_a.func_175672_r(SpawnPos);
            return new BlockPos((Vec3i)SpawnPosNew);
        }
        return super.getRandomizedSpawnPoint();
    }

    public boolean func_76567_e() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.CanRespawnHere : WorldStandardValues.CanRespawnHere.getDefaultValue();
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.ShouldMapSpin : super.shouldMapSpin(entity, x, y, z);
    }

    public boolean isDaytime() {
        return super.isDaytime();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public int getActualHeight() {
        return super.getActualHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null && dimConfig.Settings.UseCustomFogColor ? new Vec3d(dimConfig.Settings.FogColorRed, dimConfig.Settings.FogColorGreen, dimConfig.Settings.FogColorBlue) : super.func_76562_b(p_76562_1_, p_76562_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.DoesXZShowFog : WorldStandardValues.DoesXZShowFog.getDefaultValue();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_76565_k() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.VoidFogYFactor : WorldStandardValues.VoidFogYFactor.getDefaultValue();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.IsSkyColored : WorldStandardValues.IsSkyColored.getDefaultValue();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return super.getSkyColor(cameraEntity, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        return super.getCloudColor(partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? (float)dimConfig.Settings.CloudHeight : (float)WorldStandardValues.CloudHeight.getDefaultValue().intValue();
    }

    public int func_76557_i() {
        WorldConfig worldConfig = this.getWorldConfig();
        return worldConfig != null ? worldConfig.waterLevelMax + 1 : this.field_76579_a.func_181545_F() + 1;
    }

    public boolean func_186056_c(int x, int z) {
        if (this.getDimension() != 0) {
            DimensionConfig dimConfig = this.getDimensionConfig();
            return dimConfig != null ? dimConfig.Settings.CanDropChunk : WorldStandardValues.CanDropChunk.getDefaultValue();
        }
        return !this.field_76579_a.func_72916_c(x, z) || !this.field_76579_a.field_73011_w.func_186058_p().shouldLoadSpawn();
    }

    protected void func_76556_a() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        if (dimConfig != null && dimConfig.Settings.IsNightWorld) {
            for (int i = 0; i <= 15; ++i) {
                float f1 = 1.0f - (float)i / 15.0f;
                this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 0.9f + 0.1f;
            }
        } else {
            super.func_76556_a();
        }
    }

    public WorldBorder func_177501_r() {
        return new WorldBorder();
    }

    public WorldBorder createWorldBorderA(WorldBorder worldBorder) {
        ForgeWorld forgeWorld;
        DimensionConfig dimConfig;
        WorldBorder worldBorder2 = worldBorder = worldBorder != null ? worldBorder : new WorldBorder();
        if (this.field_76579_a != null && this.field_76579_a.field_73011_w != null && (dimConfig = this.getDimensionConfig()) != null && dimConfig.WorldBorderRadiusInChunks > 0 && (forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(this.field_76579_a)) != null) {
            ChunkCoordinate worldBorderCenterPoint = ChunkCoordinate.fromBlockCoords(forgeWorld.getWorld().func_72912_H().func_76079_c(), forgeWorld.getWorld().func_72912_H().func_76074_e());
            double d2 = dimConfig.WorldBorderRadiusInChunks == 0 ? 6.0E7 : (dimConfig.WorldBorderRadiusInChunks == 1 ? 16.0 : (double)(((dimConfig.WorldBorderRadiusInChunks - 1) * 2 + 1) * 16));
            worldBorder.func_177739_c((double)(worldBorderCenterPoint.getBlockX() + 8), (double)(worldBorderCenterPoint.getBlockZ() + 8));
            worldBorder.func_177750_a(d2);
        }
        return worldBorder;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        DimensionConfig dimConfig = this.getDimensionConfig();
        if (dimConfig != null && dimConfig.Settings.IsNightWorld) {
            return 0.49837038f;
        }
        return super.func_76563_a(worldTime, partialTicks);
    }

    public double getHorizon() {
        WorldConfig worldConfig = this.getWorldConfig();
        return worldConfig != null ? (double)worldConfig.waterLevelMax : (double)this.field_76579_a.func_181545_F();
    }

    public boolean canDoLightning(Chunk chunk) {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.CanDoLightning : WorldStandardValues.CanDoLightning.getDefaultValue();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.CanDoRainSnowIce : WorldStandardValues.CanDoRainSnowIce.getDefaultValue();
    }

    public boolean func_177500_n() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.DoesWaterVaporize : WorldStandardValues.DoesWaterVaporize.getDefaultValue();
    }

    public boolean func_191066_m() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.HasSkyLight : WorldStandardValues.HasSkyLight.getDefaultValue();
    }

    public void setWorldTime(long time) {
        this.field_76579_a.func_72912_H().func_76068_b(time);
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return super.getSkyRenderer();
    }

    public double getGravityFactor() {
        DimensionConfig dimConfig = this.getDimensionConfig();
        return dimConfig != null ? dimConfig.Settings.GravityFactor : WorldStandardValues.GravityFactor.getDefaultValue();
    }

    public double getFallDamageFactor(double y) {
        double baseGravityFactor = WorldStandardValues.GravityFactor.getDefaultValue();
        double gravityFactor = this.getGravityFactor();
        return y * (gravityFactor / baseGravityFactor);
    }

    public double getMovementFactor() {
        DimensionConfig worldConfig = this.getDimensionConfig();
        return worldConfig != null ? (double)worldConfig.Settings.MovementFactor : (double)WorldStandardValues.MOVEMENT_FACTOR.getDefaultValue().intValue();
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        DimensionConfig worldConfig = this.getDimensionConfig();
        return worldConfig != null ? (!worldConfig.Settings.CanRespawnHere ? worldConfig.Settings.RespawnDimension : super.getRespawnDimension(player)) : super.getRespawnDimension(player);
    }

    public boolean shouldClientCheckLighting() {
        return true;
    }
}

