/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.blocks.portal;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.blocks.portal.BlockPortalOTG;
import com.pg85.otg.forge.blocks.portal.PortalColors;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.world.ForgeWorld;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OTGBlockPortalSize {
    private final World world;
    private final EnumFacing.Axis axis;
    final EnumFacing rightDir;
    private final EnumFacing leftDir;
    public int portalBlockCount;
    BlockPos bottomLeft;
    public int height;
    public int width;
    private Block portalBlock;

    OTGBlockPortalSize(World sourceWorld, World destinationWorld, BlockPos spawnPos, EnumFacing.Axis p_i45694_3_) {
        this.world = destinationWorld;
        this.axis = p_i45694_3_;
        if (p_i45694_3_ == EnumFacing.Axis.X) {
            this.leftDir = EnumFacing.EAST;
            this.rightDir = EnumFacing.WEST;
        } else {
            this.leftDir = EnumFacing.NORTH;
            this.rightDir = EnumFacing.SOUTH;
        }
        BlockPos blockpos = spawnPos;
        while (spawnPos.func_177956_o() > blockpos.func_177956_o() - 21 && spawnPos.func_177956_o() > 0 && this.isEmptyBlock(this.world.func_180495_p(spawnPos.func_177977_b()).func_177230_c())) {
            spawnPos = spawnPos.func_177977_b();
        }
        ArrayList<LocalMaterialData> portalMaterials = null;
        if (sourceWorld.field_73011_w.getDimension() == 0) {
            portalMaterials = OTG.getDimensionsConfig().Overworld.Settings.GetDimensionPortalMaterials();
        } else {
            ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(sourceWorld);
            portalMaterials = OTG.getDimensionsConfig().getDimensionConfig((String)forgeWorld.getName()).Settings.GetDimensionPortalMaterials();
        }
        if (this.getDistanceUntilEdgeForPortalMaterials(portalMaterials, spawnPos)) {
            return;
        }
    }

    public OTGBlockPortalSize(World sourceWorld, BlockPos spawnPos, EnumFacing.Axis p_i45694_3_) {
        this.world = sourceWorld;
        this.axis = p_i45694_3_;
        if (p_i45694_3_ == EnumFacing.Axis.X) {
            this.leftDir = EnumFacing.EAST;
            this.rightDir = EnumFacing.WEST;
        } else {
            this.leftDir = EnumFacing.NORTH;
            this.rightDir = EnumFacing.SOUTH;
        }
        BlockPos blockpos = spawnPos;
        while (spawnPos.func_177956_o() > blockpos.func_177956_o() - 21 && spawnPos.func_177956_o() > 0 && this.isEmptyBlock(sourceWorld.func_180495_p(spawnPos.func_177977_b()).func_177230_c())) {
            spawnPos = spawnPos.func_177977_b();
        }
        ForgeWorld overworld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
        ArrayList<LocalWorld> forgeWorlds = ((ForgeEngine)OTG.getEngine()).getAllWorlds();
        if (overworld == null && sourceWorld.field_73011_w.getDimension() != 0) {
            ArrayList<LocalMaterialData> portalMaterials = OTG.getDimensionsConfig().Overworld.Settings.GetDimensionPortalMaterials();
            this.portalBlock = PortalColors.getPortalBlockByColor(OTG.getDimensionsConfig().Overworld.Settings.PortalColor);
            if (this.getDistanceUntilEdgeForPortalMaterials(portalMaterials, spawnPos)) {
                return;
            }
        }
        for (LocalWorld localWorld : forgeWorlds) {
            ForgeWorld forgeWorld = (ForgeWorld)localWorld;
            ArrayList<LocalMaterialData> portalMaterials = OTG.getDimensionsConfig().getDimensionConfig((String)forgeWorld.getName()).Settings.GetDimensionPortalMaterials();
            this.portalBlock = PortalColors.getPortalBlockByColor(OTG.getDimensionsConfig().getDimensionConfig((String)forgeWorld.getName()).Settings.PortalColor);
            if (forgeWorld.getDimensionId() == sourceWorld.field_73011_w.getDimension() || !this.getDistanceUntilEdgeForPortalMaterials(portalMaterials, spawnPos)) continue;
            return;
        }
    }

    private boolean getDistanceUntilEdgeForPortalMaterials(ArrayList<LocalMaterialData> portalMaterials, BlockPos p_i45694_2_) {
        int i = this.getDistanceUntilEdge(portalMaterials, p_i45694_2_, this.leftDir) - 1;
        if (i >= 0) {
            this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
            this.width = this.getDistanceUntilEdge(portalMaterials, this.bottomLeft, this.rightDir);
            if (this.width < 2 || this.width > 21) {
                this.bottomLeft = null;
                this.width = 0;
            }
        }
        if (this.bottomLeft != null) {
            this.height = this.calculatePortalHeight(portalMaterials);
        }
        return this.height > 0 && this.width > 0;
    }

    private int getDistanceUntilEdge(ArrayList<LocalMaterialData> portalMaterials, BlockPos p_180120_1_, EnumFacing p_180120_2_) {
        int i;
        for (i = 0; i < 22; ++i) {
            BlockPos blockpos = p_180120_1_.func_177967_a(p_180120_2_, i);
            Block block = this.world.func_180495_p(blockpos).func_177230_c();
            IBlockState blockStateDown = this.world.func_180495_p(blockpos.func_177977_b());
            boolean isPortalMaterial = false;
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockStateDown);
            if (material != null) {
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!material.equals(portalMaterial)) continue;
                    isPortalMaterial = true;
                }
            }
            if (!this.isEmptyBlock(block) || !isPortalMaterial) break;
        }
        IBlockState blockState = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i));
        ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
        boolean isPortalMaterial = false;
        for (LocalMaterialData portalMaterial : portalMaterials) {
            if (!material.equals(portalMaterial)) continue;
            isPortalMaterial = true;
        }
        return isPortalMaterial ? i : 0;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private int calculatePortalHeight(ArrayList<LocalMaterialData> portalMaterials) {
        this.height = 0;
        block0: while (this.height < 21) {
            for (int i = 0; i < this.width; ++i) {
                boolean isPortalMaterial;
                ForgeMaterialData material;
                IBlockState blockState;
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                Block block = this.world.func_180495_p(blockpos).func_177230_c();
                if (!this.isEmptyBlock(block)) break block0;
                if (block instanceof BlockPortalOTG) {
                    ++this.portalBlockCount;
                }
                if (i == 0) {
                    blockState = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir));
                    block = blockState.func_177230_c();
                    material = ForgeMaterialData.ofMinecraftBlockState(blockState);
                    isPortalMaterial = false;
                    for (LocalMaterialData portalMaterial : portalMaterials) {
                        if (!material.equals(portalMaterial)) continue;
                        isPortalMaterial = true;
                    }
                    if (isPortalMaterial) continue;
                    break block0;
                }
                if (i != this.width - 1) continue;
                blockState = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir));
                block = blockState.func_177230_c();
                material = ForgeMaterialData.ofMinecraftBlockState(blockState);
                isPortalMaterial = false;
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!material.equals(portalMaterial)) continue;
                    isPortalMaterial = true;
                }
                if (!isPortalMaterial) break block0;
            }
            ++this.height;
        }
        for (int j = 0; j < this.width; ++j) {
            IBlockState blockState = this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height));
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
            boolean isPortalMaterial = false;
            for (LocalMaterialData portalMaterial : portalMaterials) {
                if (!material.equals(portalMaterial)) continue;
                isPortalMaterial = true;
            }
            if (isPortalMaterial) continue;
            this.height = 0;
            break;
        }
        if (this.height <= 21 && this.height >= 3) {
            return this.height;
        }
        this.bottomLeft = null;
        this.width = 0;
        this.height = 0;
        return 0;
    }

    private boolean isEmptyBlock(Block blockIn) {
        return blockIn.func_149688_o(null) == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == Blocks.field_150427_aO || blockIn instanceof BlockPortalOTG;
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void placePortalBlocks() {
        for (int i = 0; i < this.width; ++i) {
            BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
            for (int j = 0; j < this.height; ++j) {
                this.world.func_180501_a(blockpos.func_177981_b(j), this.portalBlock.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
            }
        }
    }
}

