/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.biomes;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.generator.structure.OTGVillageGen;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.OutputType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenVillage;

public class OTGBiomeProvider
extends BiomeProvider {
    private final BiomeGenerator biomeGenerator;
    private final ForgeWorld localWorld;

    public OTGBiomeProvider(ForgeWorld world, BiomeGenerator biomeGenerator) {
        this.localWorld = world;
        this.biomeGenerator = biomeGenerator;
    }

    public Biome func_180631_a(BlockPos blockPos) {
        return ((ForgeBiome)this.localWorld.getBiome(blockPos.func_177958_n(), blockPos.func_177952_p())).getHandle();
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultOption) {
        ForgeBiome biome = (ForgeBiome)this.localWorld.getBiome(pos.func_177958_n(), pos.func_177952_p());
        if (biome != null) {
            return biome.getHandle();
        }
        return defaultOption;
    }

    public Biome[] func_76937_a(Biome[] paramArrayOfBiomeBase, int x, int z, int width, int height) {
        if (paramArrayOfBiomeBase == null || paramArrayOfBiomeBase.length < width * height) {
            paramArrayOfBiomeBase = new Biome[width * height];
        }
        int[] arrayOfInt = this.biomeGenerator.getBiomesUnZoomed(null, x, z, width, height, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < width * height; ++i) {
            paramArrayOfBiomeBase[i] = this.localWorld.getBiomeByOTGIdOrNull(arrayOfInt[i]).getHandle();
        }
        return paramArrayOfBiomeBase;
    }

    public Biome[] func_76931_a(Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        int[] arrayOfInt = this.biomeGenerator.getBiomes(null, x, z, width, length, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = this.localWorld.getBiomeByOTGIdOrNull(arrayOfInt[i]).getHandle();
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        if (allowed == MapGenVillage.field_75055_e && this.localWorld.villageGen instanceof OTGVillageGen && this.localWorld.villageGen != null) {
            allowed = ((OTGVillageGen)this.localWorld.villageGen).villageSpawnBiomes;
        }
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int m = z + radius >> 2;
        int n = k - i + 1;
        int i1 = m - j + 1;
        Biome[] arrayOfInt = this.func_76937_a(null, i, j, n, i1);
        for (int i2 = 0; i2 < n * i1; ++i2) {
            Biome localBiomeBase = arrayOfInt[i2];
            if (allowed.contains(localBiomeBase)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> allowedBiomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int m = z + range >> 2;
        int n = k - i + 1;
        int i1 = m - j + 1;
        int[] arrayOfInt = this.biomeGenerator.getBiomesUnZoomed(null, i, j, n, i1, OutputType.DEFAULT_FOR_WORLD);
        BlockPos blockPos = null;
        int i2 = 0;
        for (int i3 = 0; i3 < arrayOfInt.length; ++i3) {
            ForgeBiome biome = this.localWorld.getBiomeByOTGIdOrNull(arrayOfInt[i3]);
            int i4 = i + i3 % n << 2;
            int i5 = j + i3 / n << 2;
            Biome localBiomeBase = biome.biomeBase;
            if (!allowedBiomes.contains(localBiomeBase) || blockPos != null && random.nextInt(i2 + 1) != 0) continue;
            blockPos = new BlockPos(i4, 0, i5);
            ++i2;
        }
        return blockPos;
    }

    public void func_76938_b() {
        this.biomeGenerator.cleanupCache();
    }

    public List<Biome> func_76932_a() {
        WorldConfig worldConfig = this.localWorld.getConfigs().getWorldConfig();
        ArrayList<Biome> biomesToSpawnIn = new ArrayList<Biome>();
        ArrayList<LocalBiome> disallowedBiomes = new ArrayList<LocalBiome>();
        disallowedBiomes.add(this.localWorld.getBiomeByNameOrNull(worldConfig.defaultOceanBiome));
        disallowedBiomes.add(this.localWorld.getBiomeByNameOrNull(worldConfig.defaultFrozenOceanBiome));
        this.getAllInnerBiomes(this.localWorld.getBiomeByNameOrNull(worldConfig.defaultOceanBiome), disallowedBiomes);
        this.getAllInnerBiomes(this.localWorld.getBiomeByNameOrNull(worldConfig.defaultFrozenOceanBiome), disallowedBiomes);
        for (LocalBiome biome : this.localWorld.getAllBiomes()) {
            if (disallowedBiomes.contains(biome)) continue;
            biomesToSpawnIn.add(((ForgeBiome)biome).biomeBase);
        }
        return biomesToSpawnIn;
    }

    private void getAllInnerBiomes(LocalBiome targetBiome, List<LocalBiome> foundBiomes) {
        block0: for (LocalBiome allBiomesBiome : this.localWorld.getAllBiomes()) {
            if (!foundBiomes.contains(allBiomesBiome) && allBiomesBiome.getBiomeConfig().isleInBiome != null && allBiomesBiome.getBiomeConfig().isleInBiome.size() > 0) {
                for (String isleinBiomeName : allBiomesBiome.getBiomeConfig().isleInBiome) {
                    LocalBiome isleInBiome = this.localWorld.getBiomeByNameOrNull(isleinBiomeName);
                    if (targetBiome != isleInBiome) continue;
                    foundBiomes.add(allBiomesBiome);
                    this.getAllInnerBiomes(allBiomesBiome, foundBiomes);
                    break;
                }
            }
            if (foundBiomes.contains(allBiomesBiome) || allBiomesBiome.getBiomeConfig().biomeIsBorder == null || allBiomesBiome.getBiomeConfig().biomeIsBorder.size() <= 0) continue;
            for (String borderBiomeName : allBiomesBiome.getBiomeConfig().biomeIsBorder) {
                LocalBiome borderBiome = this.localWorld.getBiomeByNameOrNull(borderBiomeName);
                if (targetBiome != borderBiome) continue;
                foundBiomes.add(allBiomesBiome);
                this.getAllInnerBiomes(allBiomesBiome, foundBiomes);
                continue block0;
            }
        }
    }
}

