/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.minecraft.defaults.EntityNames;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public abstract class EntityFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public int y;
    public String name = "";
    public int groupSize = 1;
    public String nameTagOrNBTFileName = "";
    public String originalNameTagOrNBTFileName = "";
    public String resourceLocation = "";
    public NamedBinaryTag namedBinaryTag = null;
    public int rotation = 0;
    private String metaDataTag;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.processEntityName(args.get(3));
        this.groupSize = this.readInt(args.get(4), 0, Integer.MAX_VALUE);
        if (args.size() > 5) {
            this.processNameTagOrFileName(args.get(5));
        }
    }

    public void processEntityName(String name) {
        if (name == null) {
            return;
        }
        if (name.contains(":")) {
            this.resourceLocation = name.toLowerCase().trim();
        } else {
            this.resourceLocation = EntityNames.toInternalName(name);
            if (!this.resourceLocation.contains(":")) {
                OTG.log(LogMarker.ERROR, "Could not find entity '" + name + "', are you sure you spelled it correctly?", new Object[0]);
            }
        }
        this.name = this.resourceLocation.split(":")[1];
    }

    public void processNameTagOrFileName(String s) {
        this.originalNameTagOrNBTFileName = s;
        if (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt")) {
            this.nameTagOrNBTFileName = ((CustomObjectConfigFile)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalNameTagOrNBTFileName;
        } else if (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt")) {
            this.nameTagOrNBTFileName = ((CustomObjectConfigFile)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalNameTagOrNBTFileName;
            if (this.namedBinaryTag == null) {
                try {
                    FileInputStream stream = new FileInputStream(this.nameTagOrNBTFileName);
                    this.namedBinaryTag = NamedBinaryTag.readFrom(stream, true);
                }
                catch (FileNotFoundException e) {
                    if (OTG.getPluginConfig().spawnLog) {
                        OTG.log(LogMarker.WARN, "Could not find file: " + this.nameTagOrNBTFileName, new Object[0]);
                    }
                    this.nameTagOrNBTFileName = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.nameTagOrNBTFileName = this.originalNameTagOrNBTFileName;
        }
    }

    @Override
    public String makeString() {
        return "Entity(" + this.x + ',' + this.y + ',' + this.z + ',' + this.resourceLocation + ',' + this.groupSize + (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.length() > 0 ? ',' + this.originalNameTagOrNBTFileName : "") + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetaData() {
        if (this.nameTagOrNBTFileName != null && this.nameTagOrNBTFileName.length() > 0 && this.metaDataTag == null) {
            File metaDataFile = new File(this.nameTagOrNBTFileName);
            StringBuilder stringbuilder = new StringBuilder();
            if (metaDataFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(metaDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.metaDataTag = stringbuilder.toString();
        }
        return this.metaDataTag;
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        EntityFunction block = (EntityFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.resourceLocation.equalsIgnoreCase(this.resourceLocation) && block.groupSize == this.groupSize && block.originalNameTagOrNBTFileName.equalsIgnoreCase(this.originalNameTagOrNBTFileName);
    }

    public abstract EntityFunction<T> createNewInstance();
}

