/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3.bo3function;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Loader;
import com.pg85.otg.customobjects.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.List;
import java.util.Random;

public class BO3RandomBlockFunction
extends BO3BlockFunction {
    public LocalMaterialData[] blocks;
    public byte[] blockChances;
    public String[] metaDataNames;
    public NamedBinaryTag[] metaDataTags;
    public byte blockCount = 0;

    public BO3RandomBlockFunction() {
    }

    public BO3RandomBlockFunction(BO3Config holder) {
        super(holder);
    }

    @Override
    public BO3RandomBlockFunction rotate() {
        BO3RandomBlockFunction rotatedBlock = new BO3RandomBlockFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.blockCount = this.blockCount;
        rotatedBlock.blocks = new LocalMaterialData[this.blockCount];
        for (int i = 0; i < this.blockCount; ++i) {
            rotatedBlock.blocks[i] = this.blocks[i].rotate();
        }
        rotatedBlock.blockChances = this.blockChances;
        rotatedBlock.metaDataTags = this.metaDataTags;
        rotatedBlock.metaDataNames = this.metaDataNames;
        return rotatedBlock;
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = (short)this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        int i = 3;
        int size = args.size();
        while (i < size) {
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.readInt(args.get(i), 1, 100);
            }
            ++i;
            this.blockCount = (byte)(this.blockCount + 1);
        }
        this.blocks = new LocalMaterialData[this.blockCount];
        this.blockChances = new byte[this.blockCount];
        this.metaDataNames = new String[this.blockCount];
        this.metaDataTags = new NamedBinaryTag[this.blockCount];
        i = 3;
        this.blockCount = 0;
        while (i < size) {
            this.blocks[this.blockCount] = MaterialHelper.readMaterial(args.get(i));
            if (++i >= size) {
                throw new InvalidConfigException("Missing chance parameter");
            }
            try {
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            catch (InvalidConfigException e) {
                NamedBinaryTag metaData = BO3Loader.loadMetadata(args.get(i), ((BO3Config)this.getHolder()).getFile());
                if (metaData != null) {
                    this.metaDataNames[this.blockCount] = args.get(i);
                    this.metaDataTags[this.blockCount] = metaData;
                }
                if (++i >= size) {
                    throw new InvalidConfigException("Missing chance parameter");
                }
                this.blockChances[this.blockCount] = (byte)this.readInt(args.get(i), 1, 100);
            }
            ++i;
            this.blockCount = (byte)(this.blockCount + 1);
        }
    }

    @Override
    public String makeString() {
        String text = "RandomBlock(" + this.x + "," + this.y + "," + this.z;
        for (int i = 0; i < this.blockCount; ++i) {
            text = this.metaDataTags[i] == null ? text + "," + this.blocks[i] + "," + this.blockChances[i] : text + "," + this.blocks[i] + "," + this.metaDataNames[i] + "," + this.blockChances[i];
        }
        return text + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random random, int x, int y, int z, ChunkCoordinate chunkBeingPopulated, boolean replaceBlock) {
        for (int i = 0; i < this.blockCount; ++i) {
            if (random.nextInt(100) >= this.blockChances[i]) continue;
            world.setBlock(x, y, z, this.blocks[i], this.metaDataTags[i], chunkBeingPopulated, replaceBlock);
            break;
        }
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }
}

