/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectCollection;
import com.pg85.otg.customobjects.CustomObjectLoader;
import com.pg85.otg.customobjects.bo2.BO2Loader;
import com.pg85.otg.customobjects.bo3.BO3Loader;
import com.pg85.otg.customobjects.bo4.BO4Loader;
import com.pg85.otg.logging.LogMarker;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CustomObjectManager {
    private final Map<String, CustomObjectLoader> loaders = new HashMap<String, CustomObjectLoader>();
    private final CustomObjectCollection globalCustomObjects;

    public CustomObjectManager() {
        this.registerCustomObjectLoader("bo2", new BO2Loader());
        this.registerCustomObjectLoader("bo3", new BO3Loader());
        this.registerCustomObjectLoader("bo4", new BO4Loader());
        this.registerCustomObjectLoader("bo4data", new BO4Loader());
        this.globalCustomObjects = new CustomObjectCollection();
        new Thread(){

            @Override
            public void run() {
                CustomObjectManager.this.globalCustomObjects.indexGlobalObjectsFolder();
                for (File file : OTG.getEngine().getWorldsDirectory().listFiles()) {
                    if (!file.isDirectory()) continue;
                    String worldName = file.getName();
                    CustomObjectManager.this.globalCustomObjects.indexWorldObjectsFolder(worldName);
                }
                OTG.log(LogMarker.INFO, "All CustomObject files indexed.", new Object[0]);
            }
        }.start();
    }

    public void reloadCustomObjectFiles() {
        this.globalCustomObjects.reloadCustomObjectFiles();
    }

    private void registerCustomObjectLoader(String extension, CustomObjectLoader loader) {
        this.loaders.put(extension.toLowerCase(), loader);
    }

    public void registerGlobalObject(CustomObject object) {
        this.globalCustomObjects.addLoadedGlobalObject(object);
    }

    public CustomObjectCollection getGlobalObjects() {
        return this.globalCustomObjects;
    }

    public Map<String, CustomObjectLoader> getObjectLoaders() {
        return Collections.unmodifiableMap(this.loaders);
    }

    public void shutdown() {
        for (CustomObjectLoader loader : this.loaders.values()) {
            loader.onShutdown();
        }
        this.loaders.clear();
    }
}

