/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class ModPackConfigManager {
    private HashMap<String, DimensionsConfig> defaultConfigs = new HashMap();

    public ModPackConfigManager(File otgRootFolder) {
        this.indexModPackConfigs(otgRootFolder);
    }

    private void indexModPackConfigs(File otgRootFolder) {
        File configDir = new File(otgRootFolder.getParentFile().getParentFile() + File.separator + "config" + File.separator + "OpenTerrainGenerator" + File.separator);
        if (configDir.exists()) {
            for (File f : configDir.listFiles()) {
                DimensionsConfig forgeWorldConfig = DimensionsConfig.defaultConfigfromFile(f, otgRootFolder, true);
                if (forgeWorldConfig == null || this.defaultConfigs.containsKey(forgeWorldConfig.Overworld.PresetName)) continue;
                this.defaultConfigs.put(forgeWorldConfig.Overworld.PresetName, forgeWorldConfig);
            }
        }
    }

    public DimensionsConfig getModPackConfig(String presetName) {
        return this.defaultConfigs.get(presetName);
    }

    public void setAllModPackConfigs(ArrayList<DimensionsConfig> modPackConfigs) {
        this.defaultConfigs = new HashMap();
        for (DimensionsConfig forgeWorldConfig : modPackConfigs) {
            if (this.defaultConfigs.containsKey(forgeWorldConfig.Overworld.PresetName)) continue;
            this.defaultConfigs.put(forgeWorldConfig.Overworld.PresetName, forgeWorldConfig);
        }
    }

    public ArrayList<DimensionsConfig> getAllModPackConfigs() {
        return new ArrayList<DimensionsConfig>(this.defaultConfigs.values());
    }

    public HashMap<Integer, String> getReservedDimIds() {
        HashMap<Integer, String> reservedIds = new HashMap<Integer, String>();
        String overworldPresetName = OTG.getDimensionsConfig().Overworld.PresetName;
        for (DimensionsConfig dimsConfig : this.defaultConfigs.values()) {
            if ((overworldPresetName != null || dimsConfig.Overworld.PresetName != null) && (overworldPresetName == null || !overworldPresetName.equals(dimsConfig.Overworld.PresetName))) continue;
            for (DimensionConfig dimConfig1 : dimsConfig.Dimensions) {
                if (dimConfig1.DimensionId == 0) continue;
                reservedIds.put(dimConfig1.DimensionId, dimConfig1.PresetName);
            }
        }
        return reservedIds;
    }
}

