/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.shaded.fasterxml.jackson.annotation.JsonIgnore;
import com.pg85.otg.shaded.fasterxml.jackson.core.JsonParseException;
import com.pg85.otg.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.pg85.otg.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.pg85.otg.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.pg85.otg.shaded.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.pg85.otg.worldsave.DimensionData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;

public class DimensionsConfig {
    public String ModPackConfigName = null;
    public int ModPackConfigVersion = 0;
    File worldSavesDir;
    public boolean ShowOTGWorldCreationMenu = true;
    public int version = 0;
    private static int currentVersion = 1;
    public String WorldName;
    public DimensionConfig Overworld;
    public ArrayList<DimensionConfig> Dimensions = new ArrayList();

    public DimensionsConfig() {
    }

    public DimensionsConfig(File mcWorldSaveDir) {
        this.WorldName = mcWorldSaveDir.getName();
        this.worldSavesDir = mcWorldSaveDir.getParentFile();
    }

    public DimensionsConfig(File mcWorldSavesDir, String worldDir) {
        this.worldSavesDir = mcWorldSavesDir;
        this.WorldName = worldDir;
    }

    @JsonIgnore
    public List<DimensionConfig> getAllDimensions() {
        ArrayList<DimensionConfig> dimensions = new ArrayList<DimensionConfig>();
        if (this.Overworld != null) {
            dimensions.add(this.Overworld);
        }
        dimensions.addAll(this.Dimensions);
        return dimensions;
    }

    public String toYamlString() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void save() {
        if (this.worldSavesDir != null) {
            File dimensionsConfigFile = new File(this.worldSavesDir.getAbsolutePath() + File.separator + this.WorldName + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsConfigFileName);
            File dimensionsConfigBackupFile = new File(this.worldSavesDir.getAbsolutePath() + File.separator + this.WorldName + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsConfigBackupFileName);
            ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
            try {
                if (!dimensionsConfigFile.exists()) {
                    dimensionsConfigFile.getParentFile().mkdirs();
                    try {
                        dimensionsConfigFile.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException("Could not create " + dimensionsConfigFile.getAbsolutePath() + ", exiting.");
                    }
                } else {
                    Files.move(dimensionsConfigFile.toPath(), dimensionsConfigBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                this.version = currentVersion;
                mapper.writeValue(dimensionsConfigFile, (Object)this);
                ArrayList<String> list = new ArrayList<String>();
                BufferedReader read = new BufferedReader(new FileReader(dimensionsConfigFile));
                String dataRow = read.readLine();
                while (dataRow != null) {
                    list.add(dataRow);
                    dataRow = read.readLine();
                }
                read.close();
                FileWriter writer = new FileWriter(dimensionsConfigFile);
                String headerComments = "#TODO: Provide instructions for modpack devs.";
                writer.append(headerComments);
                for (int i = 0; i < list.size(); ++i) {
                    writer.append(System.getProperty("line.separator"));
                    writer.append((CharSequence)list.get(i));
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("OTG encountered a critical error writing " + dimensionsConfigFile.getAbsolutePath() + ", exiting. OTG automatically backs up files before writing and will try to use the backup when loading. If your world's " + WorldStandardValues.DimensionsConfigFileName + " and its backup have been corrupted, you can replace it with your own backup or create a new world with the same dimensions and copy its " + WorldStandardValues.DimensionsConfigFileName + " (edit the WorldName node if necessary).");
            }
        }
    }

    public DimensionConfig getDimensionConfig(String worldName) {
        if (worldName.equals("overworld") || worldName.equals(this.WorldName)) {
            return this.Overworld;
        }
        if (this.Dimensions != null) {
            for (DimensionConfig dimConfig : this.Dimensions) {
                if (!dimConfig.PresetName.equals(worldName)) continue;
                return dimConfig;
            }
        }
        return null;
    }

    public static DimensionsConfig fromYamlString(String readStringFromStream) {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        DimensionsConfig presetsConfig = null;
        try {
            presetsConfig = mapper.readValue(readStringFromStream, DimensionsConfig.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return presetsConfig;
    }

    static DimensionsConfig defaultConfigfromFile(File file, File otgRootFolder, boolean isModPackConfig) {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        DimensionsConfig presetsConfig = null;
        try {
            presetsConfig = mapper.readValue(file, DimensionsConfig.class);
        }
        catch (IOException e) {
            OTG.log(LogMarker.WARN, "Modpack Config " + file.getName() + " could not be read.", new Object[0]);
            e.printStackTrace();
        }
        if (presetsConfig != null) {
            DimensionsConfig.updateConfig(presetsConfig, otgRootFolder, null, isModPackConfig);
        }
        return presetsConfig;
    }

    private static void updateConfig(DimensionsConfig dimsConfig, File otgRootFolder, Path worldSaveDir, boolean isModPackConfig) {
        DimensionsConfig modPackConfig;
        boolean doSave = false;
        if (dimsConfig.version == 0) {
            Object worldConfig;
            doSave = true;
            if (dimsConfig.Overworld != null && dimsConfig.Overworld.PresetName != null && (worldConfig = WorldConfig.fromDisk(new File(otgRootFolder, "worlds" + File.separator + dimsConfig.Overworld.PresetName))) != null) {
                dimsConfig.Overworld.Settings.IsOTGPlus = ((WorldConfig)worldConfig).isOTGPlus;
            }
            if (dimsConfig.Dimensions != null) {
                for (DimensionConfig dimConfig : dimsConfig.Dimensions) {
                    WorldConfig worldConfig2 = WorldConfig.fromDisk(new File(otgRootFolder, "worlds" + File.separator + dimConfig.PresetName));
                    if (worldConfig2 == null) continue;
                    dimConfig.Settings.IsOTGPlus = worldConfig2.isOTGPlus;
                }
            }
        }
        if (!isModPackConfig && (modPackConfig = OTG.getEngine().getModPackConfigManager().getModPackConfig(dimsConfig.Overworld.PresetName)) != null && modPackConfig.ModPackConfigName != null && modPackConfig.ModPackConfigVersion > dimsConfig.ModPackConfigVersion) {
            doSave = true;
            int currentVersion = dimsConfig.ModPackConfigVersion;
            dimsConfig.ModPackConfigName = modPackConfig.ModPackConfigName;
            dimsConfig.ModPackConfigVersion = modPackConfig.ModPackConfigVersion;
            String seed = dimsConfig.Overworld.Seed;
            String gameType = dimsConfig.Overworld.GameType;
            boolean bonusChest = dimsConfig.Overworld.BonusChest;
            boolean allowCheats = dimsConfig.Overworld.AllowCheats;
            int dimId = 0;
            int pregenerationRadius = dimsConfig.Overworld.PregeneratorRadiusInChunks;
            int worldBorderRadius = dimsConfig.Overworld.WorldBorderRadiusInChunks;
            dimsConfig.Overworld = modPackConfig.Overworld.clone();
            dimsConfig.Overworld.GameType = gameType;
            dimsConfig.Overworld.BonusChest = bonusChest;
            dimsConfig.Overworld.AllowCheats = allowCheats;
            dimsConfig.Overworld.Seed = seed;
            dimsConfig.Overworld.PregeneratorRadiusInChunks = pregenerationRadius;
            dimsConfig.Overworld.WorldBorderRadiusInChunks = worldBorderRadius;
            for (DimensionConfig modPackDimConfig : modPackConfig.Dimensions) {
                boolean bFound = false;
                for (DimensionConfig dimConfig : new ArrayList<DimensionConfig>(dimsConfig.Dimensions)) {
                    if (!dimConfig.PresetName.equals(modPackDimConfig.PresetName)) continue;
                    boolean deleteDim = false;
                    if (worldSaveDir != null && modPackDimConfig.LowestSupportedModPackConfigVersion > 0 && currentVersion < modPackDimConfig.LowestSupportedModPackConfigVersion) {
                        DimensionData.deleteDimSavedData(worldSaveDir, dimConfig);
                        deleteDim = modPackDimConfig.RemoveOnUpdate;
                    }
                    bFound = true;
                    dimsConfig.Dimensions.remove(dimConfig);
                    if (deleteDim) continue;
                    seed = dimConfig.Seed;
                    gameType = dimConfig.GameType;
                    bonusChest = dimConfig.BonusChest;
                    allowCheats = dimConfig.AllowCheats;
                    dimId = dimConfig.DimensionId;
                    pregenerationRadius = dimConfig.PregeneratorRadiusInChunks;
                    worldBorderRadius = dimConfig.WorldBorderRadiusInChunks;
                    DimensionConfig modPackDimConfigClone = modPackDimConfig.clone();
                    modPackDimConfigClone.Seed = seed;
                    modPackDimConfigClone.GameType = gameType;
                    modPackDimConfigClone.BonusChest = bonusChest;
                    modPackDimConfigClone.AllowCheats = allowCheats;
                    modPackDimConfigClone.DimensionId = dimId;
                    modPackDimConfigClone.PregeneratorRadiusInChunks = pregenerationRadius;
                    modPackDimConfigClone.WorldBorderRadiusInChunks = worldBorderRadius;
                    dimsConfig.Dimensions.add(modPackDimConfigClone);
                }
                if (bFound) continue;
                dimsConfig.Dimensions.add(modPackDimConfig.clone());
            }
        }
        if (doSave) {
            dimsConfig.save();
        }
    }

    public static DimensionsConfig loadFromFile(File mcWorldSaveDir, File otgRootFolder) {
        ObjectMapper mapper;
        DimensionsConfig presetsConfig;
        File dimensionsConfigFile = new File(mcWorldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsConfigFileName);
        File dimensionsConfigBackupFile = new File(mcWorldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsConfigBackupFileName);
        if (!dimensionsConfigFile.exists() && !dimensionsConfigBackupFile.exists()) {
            return null;
        }
        if (dimensionsConfigFile.exists()) {
            presetsConfig = null;
            mapper = new ObjectMapper(new YAMLFactory());
            try {
                presetsConfig = mapper.readValue(dimensionsConfigFile, DimensionsConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                OTG.log(LogMarker.WARN, "Failed to load " + dimensionsConfigFile.getAbsolutePath() + ", trying to load backup.", new Object[0]);
            }
            if (presetsConfig != null) {
                presetsConfig.WorldName = mcWorldSaveDir.getName();
                presetsConfig.worldSavesDir = mcWorldSaveDir.getParentFile();
                try {
                    DimensionsConfig.updateConfig(presetsConfig, otgRootFolder, mcWorldSaveDir.toPath(), false);
                    return presetsConfig;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    OTG.log(LogMarker.WARN, "Failed to load " + dimensionsConfigFile.getAbsolutePath() + ", trying to load backup.", new Object[0]);
                }
            }
        }
        if (dimensionsConfigBackupFile.exists()) {
            presetsConfig = null;
            mapper = new ObjectMapper(new YAMLFactory());
            try {
                presetsConfig = mapper.readValue(dimensionsConfigBackupFile, DimensionsConfig.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (presetsConfig != null) {
                presetsConfig.WorldName = mcWorldSaveDir.getName();
                presetsConfig.worldSavesDir = mcWorldSaveDir.getParentFile();
                try {
                    DimensionsConfig.updateConfig(presetsConfig, otgRootFolder, mcWorldSaveDir.toPath(), false);
                    return presetsConfig;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        throw new RuntimeException("OTG encountered a critical error loading " + dimensionsConfigFile.getAbsolutePath() + " and could not load a backup, exiting.OTG automatically backs up files before writing and tries to use the backup when loading. If your world's " + WorldStandardValues.DimensionsConfigFileName + " and its backup have been corrupted, you can replace it with your own backup or create a new world with the same dimensions and copy its " + WorldStandardValues.DimensionsConfigFileName + " (edit the WorldName node if necessary).");
    }
}

