/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.biome.settings;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplacedBlocksMatrix {
    private static final String NO_REPLACE = "None";
    private final int maxHeight;
    private List<ReplacedBlocksInstruction> instructions;
    private final ReplaceBlockEntry[] targetsAtHeights;
    public boolean replacesCooledLava = false;
    public boolean replacesIce = false;
    public boolean replacesWater = false;
    public boolean replacesStone = false;
    public boolean replacesGround = false;
    public boolean replacesSurface = false;
    public boolean replacesBedrock = false;
    public boolean replacesSandStone = false;
    public boolean replacesRedSandStone = false;
    private boolean parsedFallBacks = false;

    public ReplacedBlocksMatrix(String setting, int maxHeight) throws InvalidConfigException {
        this.maxHeight = maxHeight;
        this.targetsAtHeights = new ReplaceBlockEntry[256];
        if (setting.isEmpty() || setting.equalsIgnoreCase(NO_REPLACE)) {
            this.setInstructions(Collections.emptyList());
            return;
        }
        ArrayList<ReplacedBlocksInstruction> instructions = new ArrayList<ReplacedBlocksInstruction>();
        String[] keys = StringHelper.readCommaSeperatedString(setting);
        for (String key : keys) {
            int start = key.indexOf(40);
            int end = key.lastIndexOf(41);
            if (start == -1 || end == -1) {
                throw new InvalidConfigException("One of the parts is missing braces around it.");
            }
            String keyWithoutBraces = key.substring(start + 1, end);
            instructions.add(new ReplacedBlocksInstruction(keyWithoutBraces, maxHeight));
        }
        this.setInstructions(instructions);
        for (ReplacedBlocksInstruction instruction : this.instructions) {
            for (int y = instruction.minHeight; y <= instruction.maxHeight && y <= 255; ++y) {
                if (y < 0) continue;
                ReplaceBlockEntry targetsAtHeight = this.targetsAtHeights[y];
                if (targetsAtHeight == null) {
                    this.targetsAtHeights[y] = targetsAtHeight = new ReplaceBlockEntry();
                }
                for (Map.Entry<Integer, LocalMaterialData> entry : targetsAtHeight.targetsWithoutBlockData.entrySet()) {
                    if ((!instruction.from.hasData() || instruction.from.hashCode() != entry.getValue().hashCode()) && (instruction.from.hasData() || instruction.from.hashCodeWithoutBlockData() != entry.getValue().hashCodeWithoutBlockData())) continue;
                    entry.setValue(instruction.to);
                }
                for (Map.Entry<Integer, LocalMaterialData> entry : targetsAtHeight.targetsWithBlockData.entrySet()) {
                    if ((!instruction.from.hasData() || instruction.from.hashCode() != entry.getValue().hashCode()) && (instruction.from.hasData() || instruction.from.hashCodeWithoutBlockData() != entry.getValue().hashCodeWithoutBlockData())) continue;
                    entry.setValue(instruction.to);
                }
                if (instruction.from.hasData()) {
                    targetsAtHeight.targetsWithBlockData.put(instruction.from.hashCode(), instruction.to);
                    continue;
                }
                targetsAtHeight.targetsWithoutBlockData.put(instruction.from.hashCodeWithoutBlockData(), instruction.to);
            }
        }
    }

    public void init(LocalMaterialData biomeCooledLavaBlock, LocalMaterialData biomeIceBlock, LocalMaterialData biomeWaterBlock, LocalMaterialData biomeStoneBlock, LocalMaterialData biomeGroundBlock, LocalMaterialData biomeSurfaceBlock, LocalMaterialData biomeBedrockBlock, LocalMaterialData biomeSandStoneBlock, LocalMaterialData biomeRedSandStoneBlock) {
        for (ReplacedBlocksInstruction instruction : this.instructions) {
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeCooledLavaBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeCooledLavaBlock.hashCode()) {
                this.replacesCooledLava = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeIceBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeIceBlock.hashCode()) {
                this.replacesIce = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeWaterBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeWaterBlock.hashCode()) {
                this.replacesWater = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeStoneBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeStoneBlock.hashCode()) {
                this.replacesStone = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeGroundBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeGroundBlock.hashCode()) {
                this.replacesGround = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeSurfaceBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeSurfaceBlock.hashCode()) {
                this.replacesSurface = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeBedrockBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeBedrockBlock.hashCode()) {
                this.replacesBedrock = true;
            }
            if (!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeSandStoneBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeSandStoneBlock.hashCode()) {
                this.replacesSandStone = true;
            }
            if (!(!instruction.from.hasData() ? instruction.from.hashCodeWithoutBlockData() == biomeRedSandStoneBlock.hashCodeWithoutBlockData() : instruction.from.hashCode() == biomeRedSandStoneBlock.hashCode())) continue;
            this.replacesRedSandStone = true;
        }
    }

    public void parseForWorld(LocalWorld world) {
        if (!this.parsedFallBacks) {
            this.parsedFallBacks = true;
            for (ReplacedBlocksInstruction instruction : this.instructions) {
                if (instruction.from != null) {
                    instruction.from.parseForWorld(world);
                }
                if (instruction.to == null) continue;
                instruction.to.parseForWorld(world);
            }
        }
    }

    public LocalMaterialData replaceBlock(int y, LocalMaterialData material) {
        ReplaceBlockEntry targetsAtHeight = this.targetsAtHeights[y];
        if (targetsAtHeight == null) {
            return material;
        }
        LocalMaterialData replaceToMaterial = targetsAtHeight.targetsWithoutBlockData.get(material.hashCodeWithoutBlockData());
        if (replaceToMaterial != null) {
            return replaceToMaterial;
        }
        replaceToMaterial = targetsAtHeight.targetsWithBlockData.get(material.hashCode());
        if (replaceToMaterial != null) {
            return replaceToMaterial;
        }
        return material;
    }

    public boolean hasReplaceSettings() {
        return this.instructions != null && this.instructions.size() > 0;
    }

    public List<ReplacedBlocksInstruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(Collection<ReplacedBlocksInstruction> instructions) {
        this.instructions = Collections.unmodifiableList(new ArrayList<ReplacedBlocksInstruction>(instructions));
        if (this.instructions.size() == 0) {
            return;
        }
    }

    public String toString() {
        if (!this.hasReplaceSettings()) {
            return NO_REPLACE;
        }
        StringBuilder builder = new StringBuilder();
        for (ReplacedBlocksInstruction instruction : this.getInstructions()) {
            builder.append('(');
            builder.append(instruction.from);
            builder.append(',').append(instruction.to);
            if (instruction.getMinHeight() != 0 || instruction.getMaxHeight() != this.maxHeight) {
                builder.append(',').append(instruction.getMinHeight());
                builder.append(',').append(instruction.getMaxHeight());
            }
            builder.append(')').append(',');
        }
        return builder.substring(0, builder.length() - 1);
    }

    public static ReplacedBlocksMatrix createEmptyMatrix(int maxHeight) {
        try {
            return new ReplacedBlocksMatrix(NO_REPLACE, maxHeight);
        }
        catch (InvalidConfigException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean replacesBlock(LocalMaterialData surfaceBlock) {
        for (ReplacedBlocksInstruction instruction : this.instructions) {
            if (!(instruction.getFrom().hasData() ? surfaceBlock.hashCode() == instruction.from.hashCode() : surfaceBlock.hashCodeWithoutBlockData() == instruction.from.hashCodeWithoutBlockData())) continue;
            return true;
        }
        return false;
    }

    public static class ReplacedBlocksInstruction {
        private final LocalMaterialData from;
        private final LocalMaterialData to;
        private final int minHeight;
        private final int maxHeight;

        private ReplacedBlocksInstruction(String instruction, int maxAllowedY) throws InvalidConfigException {
            String[] values = instruction.split(",");
            if (values.length == 5) {
                values = new String[]{values[0], values[1] + ":" + values[2], values[3], "" + (Integer.parseInt(values[4]) - 1)};
            }
            if (values.length != 2 && values.length != 4) {
                throw new InvalidConfigException("Replace parts must be in the format (from,to) or (from,to,minHeight,maxHeight)");
            }
            this.from = MaterialHelper.readMaterial(values[0]);
            this.to = MaterialHelper.readMaterial(values[1]);
            if (values.length == 4) {
                this.minHeight = StringHelper.readInt(values[2], 0, maxAllowedY);
                this.maxHeight = StringHelper.readInt(values[3], this.minHeight, maxAllowedY);
            } else {
                this.minHeight = 0;
                this.maxHeight = maxAllowedY;
            }
        }

        public ReplacedBlocksInstruction(LocalMaterialData from, LocalMaterialData to, int minHeight, int maxHeight) {
            this.from = from;
            this.to = to;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        public LocalMaterialData getFrom() {
            return this.from;
        }

        public LocalMaterialData getTo() {
            return this.to;
        }

        public int getMinHeight() {
            return this.minHeight;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }
    }

    private class ReplaceBlockEntry {
        public final HashMap<Integer, LocalMaterialData> targetsWithoutBlockData = new HashMap();
        public final HashMap<Integer, LocalMaterialData> targetsWithBlockData = new HashMap();

        private ReplaceBlockEntry() {
        }
    }
}

