/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.biome;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BiomeGroup
extends ConfigFunction<WorldConfig> {
    private int groupId;
    private String name;
    private int groupRarity;
    private int generationDepth = 0;
    private float avgTemp = 0.0f;
    private Map<String, LocalBiome> biomes = new LinkedHashMap<String, LocalBiome>(32);
    public int totalGroupRarity;
    HashMap<Integer, TreeMap<Integer, LocalBiome>> cachedDepthMapOrHigher = new HashMap();
    HashMap<Integer, TreeMap<Integer, LocalBiome>> cachedDepthMaps = new HashMap();

    public BiomeGroup(WorldConfig config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(4, args);
        this.name = args.get(0);
        this.generationDepth = this.readInt(args.get(1), 0, config.generationDepth);
        this.groupRarity = this.readInt(args.get(2), 1, Integer.MAX_VALUE);
        for (String biome : this.readBiomes(args, 3)) {
            this.biomes.put(biome, null);
        }
    }

    public BiomeGroup(WorldConfig config, String groupName, int size, int rarity, List<String> biomes) {
        super(config);
        this.name = groupName;
        this.generationDepth = size;
        this.groupRarity = rarity;
        for (String biome : biomes) {
            this.biomes.put(biome, null);
        }
    }

    public void processBiomeData(LocalWorld world) {
        float totalTemp = 0.0f;
        this.totalGroupRarity = 0;
        for (Map.Entry<String, LocalBiome> entry : this.biomes.entrySet()) {
            String biomeName = entry.getKey();
            LocalBiome localBiome = world.getBiomeByNameOrNull(biomeName);
            entry.setValue(localBiome);
            if (localBiome == null) {
                OTG.log(LogMarker.FATAL, "Could not find biome with name '" + biomeName + "' from biome group " + this.name, new Object[0]);
                throw new RuntimeException("Could not find biome with name '" + biomeName + "' from biome group " + this.name);
            }
            BiomeConfig biomeConfig = localBiome.getBiomeConfig();
            totalTemp += biomeConfig.biomeTemperature;
            this.totalGroupRarity += biomeConfig.biomeRarity;
        }
        this.avgTemp = totalTemp / (float)this.biomes.size();
    }

    @Override
    public String toString() {
        return "BiomeGroup(" + this.name + ", " + this.generationDepth + ", " + this.groupRarity + ", " + StringHelper.join(this.biomes.keySet(), ", ") + ")";
    }

    private List<String> readBiomes(List<String> strings, int start) throws InvalidConfigException {
        return new ArrayList<String>(strings.subList(start, strings.size()));
    }

    public String getName() {
        return this.name;
    }

    void filterBiomes(ArrayList<String> customBiomeNames, boolean logWarnings) {
        Iterator<String> it = this.biomes.keySet().iterator();
        while (it.hasNext()) {
            String biomeName = it.next();
            if (biomeName != null && biomeName.trim().length() > 0) {
                if (DefaultBiome.Contain(biomeName) || customBiomeNames.contains(biomeName)) continue;
                if (logWarnings) {
                    OTG.log(LogMarker.WARN, "Invalid biome name {} in biome group {}", biomeName, this.name);
                }
            }
            it.remove();
        }
    }

    public boolean containsBiome(String name) {
        return this.biomes.containsKey(name);
    }

    void setGroupId(int groupId) {
        if (groupId > 127) {
            throw new IllegalArgumentException("Tried to set group id to " + groupId + ", max allowed is " + 127);
        }
        this.groupId = groupId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean isColdGroup() {
        return this.avgTemp < 0.33f;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<WorldConfig> other) {
        if (other instanceof BiomeGroup) {
            BiomeGroup group = (BiomeGroup)other;
            return group.name.equalsIgnoreCase(this.name);
        }
        return false;
    }

    public SortedMap<Integer, LocalBiome> getDepthMapOrHigher(int depth) {
        TreeMap<Integer, LocalBiome> map = this.cachedDepthMapOrHigher.get(new Integer(depth));
        if (map != null) {
            return map;
        }
        int cumulativeBiomeRarity = 0;
        map = new TreeMap();
        for (Map.Entry<String, LocalBiome> biome : this.biomes.entrySet()) {
            if (biome.getValue().getBiomeConfig().biomeSize < depth && depth >= 0) continue;
            map.put(cumulativeBiomeRarity += biome.getValue().getBiomeConfig().biomeRarity, biome.getValue());
        }
        this.cachedDepthMapOrHigher.put(new Integer(depth), map);
        return map;
    }

    SortedMap<Integer, LocalBiome> getDepthMap(int depth) {
        TreeMap<Integer, LocalBiome> map = this.cachedDepthMaps.get(new Integer(depth));
        if (map != null) {
            return map;
        }
        int cumulativeBiomeRarity = 0;
        map = new TreeMap();
        for (Map.Entry<String, LocalBiome> biome : this.biomes.entrySet()) {
            if (biome.getValue().getBiomeConfig().biomeSize != depth && depth >= 0) continue;
            map.put(cumulativeBiomeRarity += biome.getValue().getBiomeConfig().biomeRarity, biome.getValue());
        }
        this.cachedDepthMaps.put(new Integer(depth), map);
        return map;
    }

    public int getGroupRarity() {
        return this.groupRarity;
    }

    public int getGenerationDepth() {
        return this.generationDepth;
    }

    boolean hasNoBiomes() {
        return this.biomes.isEmpty();
    }
}

