/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.io.SimpleSettingsMap;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import java.util.ArrayList;
import java.util.List;

public abstract class ConfigFile {
    private final String configName;

    protected ConfigFile(String configName) {
        this.configName = configName;
    }

    public SettingsMap getSettingsAsMap() {
        SimpleSettingsMap settingsMap = new SimpleSettingsMap(this.configName, false);
        this.writeConfigSettings(settingsMap);
        return settingsMap;
    }

    protected abstract void writeConfigSettings(SettingsMap var1);

    protected abstract void readConfigSettings(SettingsMap var1);

    protected abstract void correctSettings(boolean var1);

    protected abstract void renameOldSettings(SettingsMap var1);

    protected final int higherThanOrEqualTo(int currentValue, int minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected final double higherThan(double currentValue, double minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected final int lowerThanOrEqualTo(int currentValue, int maximumValue) {
        if (currentValue > maximumValue) {
            return maximumValue;
        }
        return currentValue;
    }

    protected ArrayList<String> filterBiomes(List<String> biomes, ArrayList<String> customBiomes) {
        ArrayList<String> output = new ArrayList<String>();
        for (String key : biomes) {
            if (customBiomes.contains(key = key.trim())) {
                output.add(key);
                continue;
            }
            if (!DefaultBiome.Contain(key)) continue;
            output.add(key);
        }
        return output;
    }

    public String getName() {
        return this.configName;
    }
}

