/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.generator.BukkitChunkBuffer;
import com.pg85.otg.bukkit.generator.OTGBlockPopulator;
import com.pg85.otg.bukkit.materials.BukkitMaterialData;
import com.pg85.otg.bukkit.util.NBTHelper;
import com.pg85.otg.bukkit.world.BukkitWorld;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.ChunkProviderOTG;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.BlockPos2D;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.Chunk;
import net.minecraft.server.v1_12_R1.DataConverter;
import net.minecraft.server.v1_12_R1.DataConverterRegistry;
import net.minecraft.server.v1_12_R1.DataConverterType;
import net.minecraft.server.v1_12_R1.DataConverterTypes;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.ITileEntity;
import net.minecraft.server.v1_12_R1.NBTTagCompound;
import net.minecraft.server.v1_12_R1.TileEntity;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

public class OTGChunkGenerator
extends ChunkGenerator {
    private DataConverter dataConverter;
    private ChunkProviderOTG chunkProviderOTG;
    private ArrayList<BlockPopulator> BlockPopulator = new ArrayList();
    private boolean NotGenerate = false;
    private OTGPlugin plugin;
    private BukkitWorld world;
    private FifoMap<BlockPos2D, LocalMaterialData[]> unloadedBlockColumnsCache;
    private FifoMap<ChunkCoordinate, ChunkGenerator.ChunkData> unloadedChunksCache;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk1;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk2;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk3;
    private Map.Entry<ChunkCoordinate, Chunk> lastUsedChunk4;
    Object chunkCacheLock = new Object();

    public OTGChunkGenerator(OTGPlugin _plugin, BukkitWorld world) {
        this.plugin = _plugin;
        this.world = world;
        this.dataConverter = DataConverterRegistry.a();
        this.unloadedBlockColumnsCache = new FifoMap(1024);
        this.unloadedChunksCache = new FifoMap(1024);
        this.lastUsedChunk1 = null;
        this.lastUsedChunk2 = null;
        this.lastUsedChunk3 = null;
        this.lastUsedChunk4 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChunkCache() {
        Object object = this.chunkCacheLock;
        synchronized (object) {
            this.lastUsedChunk1 = null;
            this.lastUsedChunk2 = null;
            this.lastUsedChunk3 = null;
            this.lastUsedChunk4 = null;
            this.unloadedBlockColumnsCache.clear();
            this.unloadedChunksCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChunkFromCache(ChunkCoordinate chunkCoordinate) {
        Object object = this.chunkCacheLock;
        synchronized (object) {
            if (this.lastUsedChunk1 != null && this.lastUsedChunk1.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk1 = null;
            } else if (this.lastUsedChunk2 != null && this.lastUsedChunk2.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk2 = null;
            } else if (this.lastUsedChunk3 != null && this.lastUsedChunk3.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk3 = null;
            } else if (this.lastUsedChunk4 != null && this.lastUsedChunk4.getKey().equals(chunkCoordinate)) {
                this.lastUsedChunk4 = null;
            }
        }
    }

    private void makeSureWorldIsInitialized(World world) {
        if (this.chunkProviderOTG == null) {
            this.plugin.onWorldInit(world);
        }
    }

    public void onInitialize(BukkitWorld _world) {
        this.chunkProviderOTG = new ChunkProviderOTG(_world.getConfigs(), _world);
        WorldConfig.TerrainMode mode = _world.getConfigs().getWorldConfig().modeTerrain;
        if (mode == WorldConfig.TerrainMode.Normal) {
            this.BlockPopulator.add(new OTGBlockPopulator(_world));
        }
        if (mode == WorldConfig.TerrainMode.NotGenerate) {
            this.NotGenerate = true;
        }
    }

    public ObjectSpawner getObjectSpawner() {
        if (this.chunkProviderOTG == null) {
            throw new RuntimeException();
        }
        return ((OTGBlockPopulator)this.BlockPopulator.get(0)).getObjectSpawner();
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        this.makeSureWorldIsInitialized(world);
        return this.BlockPopulator;
    }

    public boolean canSpawn(World world, int x, int z) {
        this.makeSureWorldIsInitialized(world);
        int y = this.getHighestBlockYInUnloadedChunk(x, z, true, false, false, true);
        return y > -1;
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunkData;
        this.makeSureWorldIsInitialized(world);
        ChunkGenerator.ChunkData chunkData2 = chunkData = this.NotGenerate ? null : (ChunkGenerator.ChunkData)this.unloadedChunksCache.get(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        if (chunkData == null) {
            chunkData = this.createChunkData(world);
            if (this.NotGenerate) {
                return chunkData;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
            BukkitChunkBuffer chunkBuffer = new BukkitChunkBuffer(chunkCoord, chunkData);
            this.chunkProviderOTG.generate(chunkBuffer);
        }
        return chunkData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int x, int z) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        Chunk chunk = null;
        Object object = this.chunkCacheLock;
        synchronized (object) {
            if (this.lastUsedChunk1 != null && this.lastUsedChunk1.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk1.getValue();
            } else if (this.lastUsedChunk2 != null && this.lastUsedChunk2.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk2.getValue();
            } else if (this.lastUsedChunk3 != null && this.lastUsedChunk3.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk3.getValue();
            } else if (this.lastUsedChunk4 != null && this.lastUsedChunk4.getKey().equals(chunkCoord)) {
                chunk = this.lastUsedChunk4.getValue();
            }
        }
        if (chunk == null) {
            chunk = this.world.getWorld().getChunkProvider().getLoadedChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
            if (chunk == null) {
                chunk = this.world.getWorld().getChunkAt(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
            }
            if (chunk != null) {
                object = this.chunkCacheLock;
                synchronized (object) {
                    this.lastUsedChunk4 = this.lastUsedChunk3;
                    this.lastUsedChunk3 = this.lastUsedChunk2;
                    this.lastUsedChunk2 = this.lastUsedChunk1;
                    this.lastUsedChunk1 = new AbstractMap.SimpleEntry<ChunkCoordinate, Chunk>(chunkCoord, chunk);
                }
            }
        }
        return chunk;
    }

    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, BiomeConfig biomeConfig) {
        if (y < 0 || y >= 256) {
            return;
        }
        try {
            IBlockData blockData = ((BukkitMaterialData)material).internalBlock();
            Chunk chunk = this.getChunk(x, z);
            if (chunk == null) {
                throw new RuntimeException("Could not provide chunk.");
            }
            BlockPosition blockPos = new BlockPosition(x, y, z);
            boolean oldCaptureBlockStates = this.world.getWorld().captureBlockStates;
            this.world.getWorld().captureBlockStates = !(blockData.getBlock() instanceof ITileEntity);
            IBlockData oldBlockData = chunk.a(blockPos, blockData);
            this.world.getWorld().captureBlockStates = oldCaptureBlockStates;
            if (oldBlockData == null) {
                return;
            }
            if (metaDataTag != null) {
                this.attachMetadata(x, y, z, metaDataTag);
            }
            this.world.getWorld().notifyAndUpdatePhysics(blockPos, chunk, oldBlockData, blockData, 18);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void notifyAndUpdatePhysics(net.minecraft.server.v1_12_R1.World _this, BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, int i) {
        Block block = newBlock.getBlock();
        if ((i & 2) != 0 && (!_this.isClientSide || (i & 4) == 0) && (chunk == null || chunk.j() && chunk.isDone() && chunk.v())) {
            _this.notify(blockposition, oldBlock, newBlock, i);
        }
        if (!_this.isClientSide && (i & 1) != 0) {
            _this.update(blockposition, oldBlock.getBlock(), true);
            if (newBlock.n()) {
                _this.updateAdjacentComparators(blockposition, block);
            }
        } else if (!_this.isClientSide && (i & 0x10) == 0) {
            _this.c(blockposition, block);
        }
    }

    private void attachMetadata(int x, int y, int z, NamedBinaryTag tag) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.setInt("x", x);
        nmsTag.setInt("y", y);
        nmsTag.setInt("z", z);
        nmsTag = this.dataConverter.a((DataConverterType)DataConverterTypes.BLOCK_ENTITY, nmsTag, -1);
        TileEntity tileEntity = this.world.getWorld().getTileEntity(new BlockPosition(x, y, z));
        if (tileEntity != null) {
            tileEntity.load(nmsTag);
        } else if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.WARN, "Skipping tile entity with id {}, cannot be placed at {},{},{}.", nmsTag.getString("id"), x, y, z);
        }
    }

    public LocalMaterialData[] getBlockColumnInUnloadedChunk(int x, int z) {
        BlockPos2D blockPos = new BlockPos2D(x, z);
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        byte blockX = (byte)(x &= 0xF);
        byte blockZ = (byte)(z &= 0xF);
        LocalMaterialData[] cachedColumn = (LocalMaterialData[])this.unloadedBlockColumnsCache.get(blockPos);
        if (cachedColumn != null) {
            return cachedColumn;
        }
        cachedColumn = new LocalMaterialData[256];
        LocalMaterialData[] blocksInColumn = new LocalMaterialData[256];
        Chunk chunk = this.world.getWorld().getChunkProvider().getLoadedChunkAt(chunkX, chunkZ);
        if (chunk == null) {
            MaterialData blockInChunk;
            ChunkGenerator.ChunkData chunkData = (ChunkGenerator.ChunkData)this.unloadedChunksCache.get(chunkCoord);
            if (chunkData == null) {
                chunkData = this.generateChunkData((World)this.world.getWorld().getWorld(), this.world.getWorld().random, chunkX, chunkZ, null);
            }
            for (int y = 0; y < 256 && (blockInChunk = chunkData.getTypeAndData((int)blockX, y, (int)blockZ)) != null; y = (int)((short)(y + 1))) {
                blocksInColumn[y] = BukkitMaterialData.ofIds(blockInChunk.getItemTypeId(), blockInChunk.getData());
            }
            this.unloadedChunksCache.put(chunkCoord, chunkData);
        } else {
            IBlockData blockInChunk;
            for (int y = 0; y < 256 && (blockInChunk = chunk.getBlockData(new BlockPosition((int)blockX, y, (int)blockZ))) != null; y = (int)((short)(y + 1))) {
                blocksInColumn[y] = BukkitMaterialData.ofMinecraftBlockData(blockInChunk);
            }
        }
        this.unloadedBlockColumnsCache.put(blockPos, cachedColumn);
        return blocksInColumn;
    }

    public double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        return this.chunkProviderOTG.getBiomeBlocksNoiseValue(blockX, blockZ);
    }

    public LocalMaterialData getMaterialInUnloadedChunk(int x, int y, int z) {
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        return blockColumn[y];
    }

    public int getHighestBlockYInUnloadedChunk(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        int height = -1;
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        for (int y = 255; y > -1; --y) {
            boolean isSolid;
            BukkitMaterialData material = (BukkitMaterialData)blockColumn[y];
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreSnow && material.isMaterial(DefaultMaterial.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return y;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return height;
    }
}

