/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands;

import com.pg85.otg.bukkit.OTGPerm;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.biomes.BukkitBiome;
import com.pg85.otg.bukkit.commands.BaseCommand;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPCommand
extends BaseCommand {
    TPCommand(OTGPlugin _plugin) {
        super(_plugin);
        this.name = "tp";
        this.perm = OTGPerm.CMD_TP.node;
        this.usage = "tp <biome/dimension name or id> [-p player]";
    }

    @Override
    public boolean onCommand(CommandSender sender, List<String> args) {
        Location location = this.getLocation(sender);
        int playerX = location.getBlockX();
        int playerZ = location.getBlockZ();
        LocalWorld world = this.getWorld(sender, "");
        if (world == null) {
            sender.sendMessage(ERROR_COLOR + "Plugin is not enabled for this world.");
            return true;
        }
        Player player = null;
        if (args.contains("-p")) {
            String name = args.get(args.size() - 1);
            player = sender.getServer().getPlayer(name);
            if (player == null) {
                sender.sendMessage(ERROR_COLOR + "Could not find player " + name);
                return true;
            }
        } else if (!(sender instanceof Player)) {
            sender.sendMessage(ERROR_COLOR + "Must be a player to send this command without player argument " + this.name);
            return true;
        }
        if (player == null) {
            player = (Player)sender;
        }
        String biomeName = "";
        for (int i = 0; i < args.size() && !args.get(i).equalsIgnoreCase("-p"); ++i) {
            biomeName = biomeName + args.get(i) + " ";
        }
        if ((biomeName = biomeName.trim()).length() > 0) {
            BukkitBiome targetBiome;
            int biomeId = -1;
            try {
                biomeId = Integer.parseInt(biomeName.replace(" ", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
            Location playerLoc = player.getLocation();
            int maxRadius = 500;
            if (biomeId == -1 && (targetBiome = (BukkitBiome)world.getBiomeByNameOrNull(biomeName)) != null) {
                biomeId = targetBiome.getIds().getOTGBiomeId();
            }
            if (biomeId != -1) {
                sender.sendMessage(MESSAGE_COLOR + "Searching for destination biome \"" + VALUE_COLOR + biomeName + MESSAGE_COLOR + "\".");
                for (int cycle = 1; cycle < maxRadius; ++cycle) {
                    for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                        for (int z1 = playerZ - cycle; z1 <= playerZ + cycle; ++z1) {
                            ChunkCoordinate chunkCoord;
                            BukkitBiome biome;
                            if (x1 != playerX - cycle && x1 != playerX + cycle && z1 != playerZ - cycle && z1 != playerZ + cycle || (biome = (BukkitBiome)world.getBiome((chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (z1 - playerZ))).getBlockXCenter(), chunkCoord.getBlockZCenter())) == null || biome.getIds().getOTGBiomeId() != biomeId) continue;
                            Location loc = new Location(playerLoc.getWorld(), (double)chunkCoord.getBlockXCenter(), (double)world.getHighestBlockAboveYAt(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter(), null), (double)chunkCoord.getBlockZCenter());
                            sender.sendMessage("Teleporting to \"" + biomeName + "\".");
                            player.teleport(loc);
                            return true;
                        }
                    }
                }
            }
            sender.sendMessage(ERROR_COLOR + "Could not find biome \"" + biomeName + "\".");
        }
        return true;
    }
}

