/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.OTG;
import com.pg85.otg.OTGEngine;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.biomes.BukkitMojangSettings;
import com.pg85.otg.bukkit.materials.BukkitMaterialData;
import com.pg85.otg.bukkit.util.BukkitLogger;
import com.pg85.otg.bukkit.util.MobSpawnGroupHelper;
import com.pg85.otg.bukkit.world.BukkitWorld;
import com.pg85.otg.bukkit.world.WorldHelper;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.MinecraftKey;
import org.bukkit.World;

public class BukkitEngine
extends OTGEngine {
    private final OTGPlugin plugin;

    BukkitEngine(OTGPlugin plugin) {
        super(new BukkitLogger(plugin.getLogger()));
        this.plugin = plugin;
    }

    @Override
    public LocalWorld getWorld(String name) {
        return this.plugin.worlds.get(name);
    }

    @Override
    public File getOTGRootFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getOTGRootFolder(), "GlobalObjects");
    }

    @Override
    public File getWorldsDirectory() {
        return new File(this.getOTGRootFolder(), "worlds");
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        return BukkitMaterialData.ofString(input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return BukkitMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }

    @Override
    public ArrayList<LocalWorld> getAllWorlds() {
        ArrayList<LocalWorld> worlds = new ArrayList<LocalWorld>();
        worlds.addAll(this.plugin.worlds.values());
        return worlds;
    }

    @Override
    public Collection<BiomeLoadInstruction> getDefaultBiomes() {
        ArrayList<BiomeLoadInstruction> standardBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(BukkitMojangSettings.fromId(id), 128);
            standardBiomes.add(instruction);
        }
        return standardBiomes;
    }

    @Override
    public LocalWorld getUnloadedWorld(String name) {
        return null;
    }

    @Override
    public boolean isModLoaded(String mod) {
        return false;
    }

    @Override
    public boolean areEnoughBiomeIdsAvailableForPresets(ArrayList<String> presetNames) {
        return true;
    }

    @Override
    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub, String biomeResourceLocation) {
        BiomeBase biome = (BiomeBase)BiomeBase.REGISTRY_ID.get((Object)new MinecraftKey(biomeResourceLocation));
        if (biome != null) {
            biomeConfigStub.spawnMonstersMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnMonstersMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.MONSTER));
            biomeConfigStub.spawnCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.CREATURE));
            biomeConfigStub.spawnAmbientCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnAmbientCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.AMBIENT_CREATURE));
            biomeConfigStub.spawnWaterCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnWaterCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.WATER_CREATURE));
        } else {
            OTG.log(LogMarker.WARN, "Biome " + biomeResourceLocation + " not found for InheritMobsFromBiomeName in " + biomeConfigStub.getBiomeName() + ".bc", new Object[0]);
        }
    }

    public void onSave(BukkitWorld bukkitWorld) {
        if (bukkitWorld != null && bukkitWorld.getObjectSpawner().saveRequired && !bukkitWorld.getWorldSession().getPreGeneratorIsRunning()) {
            bukkitWorld.getStructureCache().saveToDisk();
        }
    }

    public void onSave(World world) {
        this.onSave((BukkitWorld)WorldHelper.toLocalWorld(world));
    }
}

