/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.item;

import java.util.List;
import javax.annotation.Nullable;
import lykrast.defiledlands.common.init.ModItems;
import lykrast.defiledlands.common.util.LocUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class ItemTears
extends Item {
    protected int warmup;
    protected int tickRate;

    public ItemTears(int durability, int warmup, int tickRate) {
        this.field_77777_bU = 1;
        this.func_77656_e(durability);
        this.warmup = 72000 - warmup;
        this.tickRate = tickRate;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (count <= this.warmup && (this.warmup - count) % this.tickRate == 0) {
            this.fire(stack, player, this.warmup - count);
        }
    }

    protected abstract void fire(ItemStack var1, EntityLivingBase var2, int var3);

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ModItems.remorsefulGem;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.addAll(LocUtils.getTooltips(TextFormatting.GRAY.toString() + I18n.func_135052_a((String)(super.func_77667_c(stack) + ".tooltip"), (Object[])new Object[0])));
    }

    public static class Shulker
    extends ItemTears {
        public Shulker(int durability) {
            super(durability, 20, 20);
        }

        @Override
        protected void fire(ItemStack stack, EntityLivingBase player, int time) {
            World world = player.field_70170_p;
            if (!world.field_72995_K) {
                AxisAlignedBB aabb = player.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0);
                List targets = world.func_175674_a((Entity)player, aabb, IMob.field_175450_e);
                if (!targets.isEmpty()) {
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187789_eW, SoundCategory.NEUTRAL, 2.0f, (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.2f + 1.0f);
                    stack.func_77972_a(1, player);
                }
                for (Entity e : targets) {
                    EnumFacing.Axis axis = EnumFacing.Axis.values()[field_77697_d.nextInt(3)];
                    EntityShulkerBullet entityshulkerbullet = new EntityShulkerBullet(world, player, e, axis);
                    entityshulkerbullet.field_70163_u += (double)player.func_70047_e();
                    world.func_72838_d((Entity)entityshulkerbullet);
                }
            }
        }

        public boolean func_77636_d(ItemStack stack) {
            return true;
        }
    }

    public static class Flame
    extends ItemTears {
        public Flame(int durability) {
            super(durability, 20, 5);
        }

        @Override
        protected void fire(ItemStack stack, EntityLivingBase player, int time) {
            World world = player.field_70170_p;
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187606_E, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                Vec3d vec3d = player.func_70676_i(1.0f);
                EntitySmallFireball projectile = new EntitySmallFireball(world, player, 0.0, 0.0, 0.0);
                projectile.field_70232_b = vec3d.field_72450_a * 0.2;
                projectile.field_70233_c = vec3d.field_72448_b * 0.2;
                projectile.field_70230_d = vec3d.field_72449_c * 0.2;
                projectile.field_70163_u = player.field_70163_u + (double)player.func_70047_e();
                world.func_72838_d((Entity)projectile);
                if (time % 25 == 0) {
                    stack.func_77972_a(1, player);
                }
            }
        }

        public boolean func_77636_d(ItemStack stack) {
            return true;
        }
    }
}

