/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.entity.boss;

import java.util.Random;
import javax.annotation.Nullable;
import lykrast.defiledlands.common.entity.IEntityDefiled;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityMourner
extends EntityMob
implements IEntityDefiled {
    public static final ResourceLocation LOOT = new ResourceLocation("defiledlands", "entities/the_mourner");
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntityMourner.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> MOURNER_FLAGS = EntityDataManager.func_187226_a(EntityMourner.class, (DataSerializer)DataSerializers.field_187191_a);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    public static final int ATTACK_FIREBALLS = 0;
    public static final int ATTACK_SHULKER = 1;
    public static final int ATTACK_GHAST = 2;

    public EntityMourner(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 2.4f);
        this.field_70728_aV = 200;
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIChargeAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIRangedAttack(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(MOURNER_FLAGS, (Object)0);
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getInvulTime() > 0) {
            this.field_70181_x = 0.01;
            if (this.field_70170_p.field_72995_K) {
                for (int i1 = 0; i1 < 3; ++i1) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian(), (double)0.7f, (double)0.7f, (double)0.9f, new int[0]);
                }
            } else {
                int i = this.getInvulTime();
                if (i > 60 && i % 40 == 0 || i <= 60 && i % 10 == 0) {
                    int y = (int)this.field_70163_u + this.field_70146_Z.nextInt(11);
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((int)this.field_70165_t + this.field_70146_Z.nextInt(15) - 7, y, (int)this.field_70161_v + this.field_70146_Z.nextInt(15) - 7);
                    while (pos.func_177956_o() > 0 && y - pos.func_177956_o() < 16 && this.field_70170_p.func_175623_d((BlockPos)pos)) {
                        pos.func_185336_p(pos.func_177956_o() - 1);
                    }
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), true));
                }
            }
        }
        if (this.field_70170_p.field_72995_K && this.isFiring()) {
            EnumParticleTypes particle = EnumParticleTypes.BARRIER;
            switch (this.getCurrentAttack()) {
                case 0: {
                    particle = EnumParticleTypes.FLAME;
                    break;
                }
                case 1: {
                    particle = EnumParticleTypes.END_ROD;
                    break;
                }
                case 2: {
                    particle = EnumParticleTypes.SMOKE_LARGE;
                }
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(particle, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    protected void func_70619_bc() {
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 7.0f, false, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
                this.func_184185_a(SoundEvents.field_187855_gD, 10.0f, 1.0f);
            }
            this.setInvulTime(j1);
        } else {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            int force = 6;
            entityIn.field_70181_x += 0.4;
            if (entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)force * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            } else {
                entityIn.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)force * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * (float)force * 0.5f));
            }
            return true;
        }
        return false;
    }

    public void ignite() {
        this.setInvulTime(200);
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        float f = super.func_180428_a(explosionIn, worldIn, pos, blockStateIn);
        Block block = blockStateIn.func_177230_c();
        if (EntityWither.func_181033_a((Block)block) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)pos, (IBlockState)blockStateIn)) {
            f = Math.min(2.0f, f);
        }
        return f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntityMourner)) {
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ >= 180 && this.field_70725_aQ <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 4.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 8.0f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        boolean flag = this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
        int i = this.field_70728_aV;
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70725_aQ > 150 && this.field_70725_aQ % 5 == 0 && flag) {
                this.dropExperience(MathHelper.func_76141_d((float)((float)i * 0.08f)));
            }
            if (this.field_70725_aQ == 1) {
                this.func_184185_a(SoundEvents.field_187522_aL, 10.0f, 1.0f);
            }
        }
        this.field_70181_x = 0.01;
        if (this.field_70725_aQ >= 200) {
            if (!this.field_70170_p.field_72995_K) {
                if (flag) {
                    this.dropExperience(MathHelper.func_76141_d((float)((float)i * 0.2f)));
                }
                this.func_70106_y();
            }
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1, new int[0]);
            }
        }
    }

    private void dropExperience(int p_184668_1_) {
        while (p_184668_1_ > 0) {
            int i = EntityXPOrb.func_70527_a((int)p_184668_1_);
            p_184668_1_ -= i;
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, i));
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Invul", this.getInvulTime());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setInvulTime(compound.func_74762_e("Invul"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    private boolean getMournerFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(MOURNER_FLAGS);
        return (i & mask) != 0;
    }

    private void setMournerFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(MOURNER_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(MOURNER_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getMournerFlag(1);
    }

    public void setIsCharging(boolean value) {
        this.setMournerFlag(1, value);
    }

    public boolean isFiring() {
        return this.getMournerFlag(2);
    }

    public void setIsFiring(boolean value) {
        this.setMournerFlag(2, value);
    }

    public int getCurrentAttack() {
        byte i = (Byte)this.field_70180_af.func_187225_a(MOURNER_FLAGS);
        return i >>> 2;
    }

    public void setCurrentAttack(int value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(MOURNER_FLAGS)).byteValue();
        i &= 3;
        this.field_70180_af.func_187227_b(MOURNER_FLAGS, (Object)((byte)((i |= value << 2) & 0xFF)));
    }

    public int getRageFactor() {
        float h = this.func_110143_aJ();
        if (h < 100.0f) {
            return 3;
        }
        if (h < 200.0f) {
            return 2;
        }
        return 1;
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187851_gB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187849_gA;
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    protected boolean attemptTeleportAir(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                flag = true;
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (this instanceof EntityCreature) {
            this.func_70661_as().func_75499_g();
        }
        return true;
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private EntityMourner mourner;

        public AIMoveRandom(EntityMourner mourner) {
            this.func_75248_a(1);
            this.mourner = mourner;
        }

        public boolean func_75250_a() {
            return !this.mourner.func_70605_aq().func_75640_a() && this.mourner.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = this.mourner.func_70638_az() != null && this.mourner.func_70638_az().func_70089_S() ? new BlockPos((Entity)this.mourner.func_70638_az()) : new BlockPos((Entity)this.mourner);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.mourner.field_70146_Z.nextInt(15) - 7, this.mourner.field_70146_Z.nextInt(11) - 5, this.mourner.field_70146_Z.nextInt(15) - 7);
                if (!this.mourner.field_70170_p.func_175623_d(blockpos1)) continue;
                this.mourner.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25 * (double)this.mourner.getRageFactor());
                if (this.mourner.func_70638_az() != null) break;
                this.mourner.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    static class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityMourner mourner) {
            super((EntityLiving)mourner);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < this.field_75648_a.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    this.field_75648_a.field_70159_w *= 0.5;
                    this.field_75648_a.field_70181_x *= 0.5;
                    this.field_75648_a.field_70179_y *= 0.5;
                } else if (d3 >= 20.0 && ((EntityMourner)this.field_75648_a).attemptTeleportAir(this.field_75646_b, this.field_75647_c, this.field_75644_d)) {
                    this.field_75648_a.field_70170_p.func_184148_a((EntityPlayer)null, this.field_75648_a.field_70169_q, this.field_75648_a.field_70167_r, this.field_75648_a.field_70166_s, SoundEvents.field_187534_aX, this.field_75648_a.func_184176_by(), 1.0f, 1.0f);
                    this.field_75648_a.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                } else {
                    this.field_75648_a.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    this.field_75648_a.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    this.field_75648_a.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (this.field_75648_a.func_70638_az() == null) {
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = -((float)MathHelper.func_181159_b((double)this.field_75648_a.field_70159_w, (double)this.field_75648_a.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = this.field_75648_a.func_70638_az().field_70165_t - this.field_75648_a.field_70165_t;
                        double d5 = this.field_75648_a.func_70638_az().field_70161_v - this.field_75648_a.field_70161_v;
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    static class AIRangedAttack
    extends EntityAIBase {
        private EntityMourner mourner;
        private int attackStep;
        private int attackTime;

        public AIRangedAttack(EntityMourner mourner) {
            this.func_75248_a(2);
            this.mourner = mourner;
        }

        public boolean func_75250_a() {
            return this.mourner.func_70638_az() != null && !this.mourner.func_70605_aq().func_75640_a() && !this.mourner.isCharging() && this.mourner.field_70146_Z.nextInt(9 - this.mourner.getRageFactor() * 2) == 0;
        }

        public boolean func_75253_b() {
            return this.attackStep > 0 && this.mourner.isFiring() && this.mourner.func_70638_az() != null && this.mourner.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 2 + this.mourner.getRageFactor() * 3;
            this.attackTime = 60;
            this.mourner.setIsFiring(true);
            this.mourner.setCurrentAttack(this.mourner.field_70146_Z.nextInt(3));
        }

        public void func_75251_c() {
            this.mourner.setIsFiring(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.mourner.func_70638_az();
            --this.attackTime;
            if (this.attackTime <= 0) {
                --this.attackStep;
                this.attackTime = 3;
                switch (this.mourner.getCurrentAttack()) {
                    case 0: {
                        double d0 = this.mourner.func_70068_e((Entity)entitylivingbase);
                        double d1 = entitylivingbase.field_70165_t - this.mourner.field_70165_t;
                        double d2 = entitylivingbase.func_174813_aQ().field_72338_b + (double)entitylivingbase.field_70131_O / 2.0 - (this.mourner.field_70163_u + (double)this.mourner.field_70131_O / 2.0);
                        double d3 = entitylivingbase.field_70161_v - this.mourner.field_70161_v;
                        float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                        this.mourner.field_70170_p.func_180498_a((EntityPlayer)null, 1018, new BlockPos((int)this.mourner.field_70165_t, (int)this.mourner.field_70163_u, (int)this.mourner.field_70161_v), 0);
                        EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.mourner.field_70170_p, (EntityLivingBase)this.mourner, d1 + this.mourner.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.mourner.func_70681_au().nextGaussian() * (double)f);
                        entitysmallfireball.field_70163_u = this.mourner.field_70163_u + (double)this.mourner.field_70131_O / 2.0 + 0.5;
                        this.mourner.field_70170_p.func_72838_d((Entity)entitysmallfireball);
                        break;
                    }
                    case 1: {
                        EnumFacing.Axis axis = EnumFacing.Axis.values()[this.mourner.field_70146_Z.nextInt(3)];
                        EntityShulkerBullet entityshulkerbullet = new EntityShulkerBullet(this.mourner.field_70170_p, (EntityLivingBase)this.mourner, (Entity)entitylivingbase, axis);
                        entityshulkerbullet.field_70163_u += (double)this.mourner.field_70131_O / 2.0 + 0.5;
                        this.mourner.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                        this.mourner.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (this.mourner.field_70146_Z.nextFloat() - this.mourner.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                        break;
                    }
                    case 2: {
                        Vec3d vec3d = this.mourner.func_70676_i(1.0f);
                        double d2 = entitylivingbase.field_70165_t - (this.mourner.field_70165_t + vec3d.field_72450_a * 4.0);
                        double d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (0.5 + this.mourner.field_70163_u + (double)(this.mourner.field_70131_O / 2.0f));
                        double d4 = entitylivingbase.field_70161_v - (this.mourner.field_70161_v + vec3d.field_72449_c * 4.0);
                        this.mourner.field_70170_p.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this.mourner), 0);
                        EntityLargeFireball entitylargefireball = new EntityLargeFireball(this.mourner.field_70170_p, (EntityLivingBase)this.mourner, d2, d3, d4);
                        entitylargefireball.field_92057_e = this.mourner.getRageFactor();
                        entitylargefireball.field_70165_t = this.mourner.field_70165_t;
                        entitylargefireball.field_70163_u = this.mourner.field_70163_u + (double)this.mourner.field_70131_O + 0.5;
                        entitylargefireball.field_70161_v = this.mourner.field_70161_v;
                        this.mourner.field_70170_p.func_72838_d((Entity)entitylargefireball);
                        --this.attackStep;
                        this.attackTime = 10;
                    }
                }
            }
            this.mourner.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
            super.func_75246_d();
        }
    }

    static class AIChargeAttack
    extends EntityAIBase {
        private EntityMourner mourner;

        public AIChargeAttack(EntityMourner mourner) {
            this.func_75248_a(1);
            this.mourner = mourner;
        }

        public boolean func_75250_a() {
            return this.mourner.func_70638_az() != null && this.mourner.func_70638_az().func_70089_S() && this.mourner.func_70068_e((Entity)this.mourner.func_70638_az()) <= 16.0;
        }

        public boolean func_75253_b() {
            return this.mourner.func_70605_aq().func_75640_a() && this.mourner.isCharging() && this.mourner.func_70638_az() != null && this.mourner.func_70638_az().func_70089_S() && this.mourner.func_70068_e((Entity)this.mourner.func_70638_az()) <= 25.0;
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = this.mourner.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            this.mourner.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.5 * (double)(this.mourner.getRageFactor() + 1));
            this.mourner.setIsCharging(true);
            this.mourner.setIsFiring(false);
            this.mourner.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            this.mourner.setIsCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.mourner.func_70638_az();
            if (this.mourner.func_174813_aQ().func_186662_g(0.5).func_72326_a(entitylivingbase.func_174813_aQ())) {
                this.mourner.func_70652_k((Entity)entitylivingbase);
                this.mourner.func_184609_a(EnumHand.MAIN_HAND);
                this.mourner.setIsCharging(false);
            } else {
                Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                this.mourner.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b - 1.0, vec3d.field_72449_c, 0.5 * (double)(this.mourner.getRageFactor() + 1));
            }
        }
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntityMourner.this.getInvulTime() > 0;
        }
    }
}

