/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import snownee.kiwi.KiwiConfig;
import snownee.kiwi.util.definition.ItemDefinition;

public final class OreUtil {
    public static boolean doesItemHaveOreName(ItemStack stack, String ore) {
        if (stack.func_190926_b() || !OreDictionary.doesOreNameExist((String)ore)) {
            return false;
        }
        int oreid = OreDictionary.getOreID((String)ore);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (oreid != id) continue;
            return true;
        }
        return false;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> names = new ArrayList<String>(4);
        if (!stack.func_190926_b()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                names.add(OreDictionary.getOreName((int)id));
            }
        }
        return names;
    }

    public static ItemStack getPreferredItemFromOre(String ore) {
        ItemStack preferred = ItemStack.field_190927_a;
        int i = Integer.MAX_VALUE;
        block0: for (ItemStack item : OreDictionary.getOres((String)ore, (boolean)false)) {
            if (i == Integer.MAX_VALUE && preferred.func_190926_b()) {
                preferred = item;
            }
            String modid = item.func_77973_b().getCreatorModId(item);
            for (int j = 0; j <= Math.min(i, KiwiConfig.GENERAL.orePreference.length - 1); ++j) {
                if (!modid.equals(KiwiConfig.GENERAL.orePreference[j])) continue;
                i = j;
                preferred = item;
                if (i != 0) continue block0;
                break block0;
            }
        }
        if (!(preferred = preferred.func_77946_l()).func_190926_b() && preferred.func_77960_j() == Short.MAX_VALUE) {
            preferred.func_77964_b(0);
        }
        return preferred;
    }

    public static NonNullList<ItemDefinition> getItemsFromOre(String ore) {
        LinkedHashSet<ItemDefinition> set = new LinkedHashSet<ItemDefinition>();
        if (!ore.isEmpty()) {
            for (ItemStack item : OreDictionary.getOres((String)ore, (boolean)false)) {
                if (item.func_77960_j() == Short.MAX_VALUE) {
                    NonNullList subItems = NonNullList.func_191196_a();
                    item.func_77973_b().func_150895_a(item.func_77973_b().func_77640_w(), subItems);
                    set.addAll(subItems.stream().map(ItemDefinition::of).collect(Collectors.toList()));
                    continue;
                }
                set.add(ItemDefinition.of(item));
            }
        }
        return NonNullList.func_193580_a((Object)ItemDefinition.EMPTY, (Object[])set.toArray(new ItemDefinition[0]));
    }

    public static NonNullList<ItemStack> getItemsFromOre(String ore, int count) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])OreUtil.getItemsFromOre(ore).stream().map(ItemDefinition::getItemStack).peek(i -> i.func_190920_e(count)).toArray(ItemStack[]::new));
    }
}

