/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import snownee.kiwi.crafting.input.ProcessingInput;

public class InventoryUtil {
    private InventoryUtil() {
    }

    public static boolean canMergeStacks(IInventory inventory, ItemStack stack1, ItemStack stack2) {
        return !stack1.func_190926_b() && InventoryUtil.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d() && stack1.func_190916_E() < inventory.func_70297_j_();
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static List<ItemStack> mergeItemStacks(List<ItemStack> stacks, boolean checkLimit) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            boolean flag = true;
            for (ItemStack newStack : newStacks) {
                if (!newStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)newStack)) continue;
                newStack.func_190917_f(stack.func_190916_E());
                flag = false;
                break;
            }
            if (!flag) continue;
            newStacks.add(stack.func_77946_l());
        }
        return newStacks;
    }

    public static boolean consumeItemStack(IItemHandler itemHandler, ItemStack stack, boolean simulated) {
        if (stack.func_190926_b()) {
            return true;
        }
        stack = stack.func_77946_l();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extracted;
            if (!stack.func_77969_a(itemHandler.getStackInSlot(i)) || (extracted = itemHandler.extractItem(i, stack.func_190916_E(), simulated)).func_190926_b()) continue;
            stack.func_190918_g(extracted.func_190916_E());
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeItemStack(IItemHandler itemHandler, ProcessingInput input, int count, boolean simulated) {
        if (input.isEmpty()) {
            return true;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extracted;
            if (!input.matches(itemHandler.getStackInSlot(i)) || (extracted = itemHandler.extractItem(i, count, simulated)).func_190926_b() || (count -= extracted.func_190916_E()) != 0) continue;
            return true;
        }
        return false;
    }
}

