/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.transmutations;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;

public class TransmutationRegistry {
    private static Map<Item, Map<IBlockState, IBlockState>> reagentStateMap = new HashMap<Item, Map<IBlockState, IBlockState>>();

    public static Map<Item, Map<IBlockState, IBlockState>> getReagentStateMap() {
        return reagentStateMap;
    }

    public static Map<IBlockState, IBlockState> getStateMapByReagent(Item item) {
        return reagentStateMap.get(item);
    }

    public static void initDefaultMap() {
        int i;
        Item item = Items.field_185161_cS;
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_150440_ba, Blocks.field_150423_aK);
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_189877_df, Blocks.field_150432_aD);
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_150432_aD, Blocks.field_189877_df);
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_150348_b, Blocks.field_150377_bs);
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_150377_bs, Blocks.field_150348_b);
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_150435_aG, Blocks.field_150405_ch);
        TransmutationRegistry.addEntryToReagentByBlockDefaultState(item, Blocks.field_150405_ch, Blocks.field_150435_aG);
        TransmutationRegistry.addEntryToReagent(item, Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(true)), Blocks.field_150360_v.func_176223_P());
        TransmutationRegistry.addEntryToReagent(item, Blocks.field_150360_v.func_176223_P(), Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(true)));
        TransmutationRegistry.addEntryToReagent(item, Blocks.field_180397_cI.func_176223_P(), Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.BRICKS));
        TransmutationRegistry.addEntryToReagent(item, Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.BRICKS), Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.DARK));
        TransmutationRegistry.addEntryToReagent(item, Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.DARK), Blocks.field_180397_cI.func_176223_P());
        for (EnumFacing face : EnumFacing.field_176754_o) {
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_185512_D, (Comparable)face), Blocks.field_150440_ba.func_176223_P());
        }
        for (i = 0; i < 6; ++i) {
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150345_g.func_176203_a(i), Blocks.field_150345_g.func_176203_a(i == 5 ? 0 : i + 1));
        }
        for (i = 0; i < 16; ++i) {
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150325_L.func_176203_a(i), Blocks.field_150325_L.func_176203_a(i == 15 ? 0 : i + 1));
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150406_ce.func_176203_a(i), Blocks.field_150406_ce.func_176203_a(i == 15 ? 0 : i + 1));
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150399_cn.func_176203_a(i), Blocks.field_150399_cn.func_176203_a(i == 15 ? 0 : i + 1));
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150397_co.func_176203_a(i), Blocks.field_150397_co.func_176203_a(i == 15 ? 0 : i + 1));
            TransmutationRegistry.addEntryToReagent(item, Blocks.field_150404_cg.func_176203_a(i), Blocks.field_150404_cg.func_176203_a(i == 15 ? 0 : i + 1));
        }
    }

    public static boolean doesStateMapContainKeyState(IBlockState state, Map<IBlockState, IBlockState> stateMap) {
        return stateMap.containsKey(state);
    }

    public static boolean doesReagentStateMapContainReagentItem(Item item) {
        return reagentStateMap.containsKey(item);
    }

    public static void addEntryToReagentByBlockDefaultState(Item item, Block block1, Block block2) {
        if (reagentStateMap.containsKey(item)) {
            Map<IBlockState, IBlockState> map = reagentStateMap.get(item);
            map.put(block1.func_176223_P(), block2.func_176223_P());
        } else {
            HashMap<IBlockState, IBlockState> stateMap = new HashMap<IBlockState, IBlockState>();
            stateMap.put(block1.func_176223_P(), block2.func_176223_P());
            reagentStateMap.put(item, stateMap);
        }
    }

    public static void addEntryToReagent(Item item, IBlockState state1, IBlockState state2) {
        if (reagentStateMap.containsKey(item)) {
            Map<IBlockState, IBlockState> map = reagentStateMap.get(item);
            map.put(state1, state2);
        } else {
            HashMap<IBlockState, IBlockState> stateMap = new HashMap<IBlockState, IBlockState>();
            stateMap.put(state1, state2);
            reagentStateMap.put(item, stateMap);
        }
    }

    public static void addEntriesToReagent(Item item, Map<IBlockState, IBlockState> map) {
        if (reagentStateMap.containsKey(item)) {
            Map<IBlockState, IBlockState> mapster = reagentStateMap.get(item);
            for (Map.Entry<IBlockState, IBlockState> entry : map.entrySet()) {
                mapster.put(entry.getKey(), entry.getValue());
            }
        } else {
            HashMap<IBlockState, IBlockState> stateMap = new HashMap<IBlockState, IBlockState>();
            for (Map.Entry<IBlockState, IBlockState> entry : map.entrySet()) {
                stateMap.put(entry.getKey(), entry.getValue());
            }
            reagentStateMap.put(item, stateMap);
        }
    }

    public static void addEntryReagentAgnostic(IBlockState state1, IBlockState state2) {
        for (Item key : reagentStateMap.keySet()) {
            Map<IBlockState, IBlockState> map = reagentStateMap.get(key);
            map.put(state1, state2);
        }
    }

    public static void addEntriesReagentAgnostic(Map<IBlockState, IBlockState> mapster) {
        for (Item key : reagentStateMap.keySet()) {
            Map<IBlockState, IBlockState> map = reagentStateMap.get(key);
            for (Map.Entry<IBlockState, IBlockState> entry : mapster.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void removeStartStateFromReagentAgnostic(IBlockState state) {
        for (Item reagent : reagentStateMap.keySet()) {
            reagentStateMap.get(reagent).remove(state);
        }
    }

    public static void removeEndStateFromReagentAgnostic(IBlockState state) {
        for (Item reagent : reagentStateMap.keySet()) {
            for (Map.Entry<IBlockState, IBlockState> stateEntry : reagentStateMap.get(reagent).entrySet()) {
                if (stateEntry.getValue() != state) continue;
                reagentStateMap.get(reagent).remove(stateEntry.getKey());
            }
        }
    }

    public static void removeStartStateFromReagent(Item reagent, IBlockState state) {
        reagentStateMap.get(reagent).remove(state);
    }

    public static void removeEndStateFromReagent(Item reagent, IBlockState state) {
        for (Map.Entry<IBlockState, IBlockState> stateEntry : reagentStateMap.get(reagent).entrySet()) {
            if (stateEntry.getValue() != state) continue;
            reagentStateMap.get(reagent).remove(stateEntry.getKey());
        }
    }

    public static void clearMapOfReagent(Item stack) {
        reagentStateMap.remove(stack);
    }

    public static void clearReagentOfEntries(Item stack) {
        reagentStateMap.get(stack).clear();
    }

    public static void clearReagentMap() {
        reagentStateMap.clear();
    }
}

