/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.singletonevents.mixins.blocks;

import java.lang.ref.WeakReference;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mirror.normalasm.common.singletonevents.IRefreshEvent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockEvent.NeighborNotifyEvent.class})
public class NeighborNotifyEventMixin
extends BlockEvent
implements IRefreshEvent {
    @Shadow
    @Final
    @Mutable
    private EnumSet<EnumFacing> notifiedSides;
    @Shadow
    @Final
    @Mutable
    private boolean forceRedstoneUpdate;
    @Unique
    private EventPriority normalPriority;
    @Unique
    private WeakReference<World> normalWorldRef;
    @Unique
    private BlockPos normalPos;
    @Unique
    private IBlockState normalState;

    NeighborNotifyEventMixin(World world, BlockPos pos, IBlockState state) {
        super(world, pos, state);
        throw new AssertionError();
    }

    public World getWorld() {
        return (World)this.normalWorldRef.get();
    }

    public BlockPos getPos() {
        return this.normalPos;
    }

    public IBlockState getState() {
        return this.normalState;
    }

    @Override
    public void beforeNeighborNotify(World world, BlockPos pos, IBlockState state, EnumSet<EnumFacing> notifiedSides, boolean forceRedstoneUpdate) {
        this.normalWorldRef = new WeakReference<World>(world);
        this.normalPos = pos;
        this.normalState = state;
        this.notifiedSides = notifiedSides;
        this.forceRedstoneUpdate = forceRedstoneUpdate;
    }

    @Nullable
    public EventPriority getPhase() {
        return this.normalPriority;
    }

    public void setPhase(@Nonnull EventPriority next) {
        this.normalPriority = next;
    }
}

