/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.java;

import com.google.common.base.Stopwatch;
import java.lang.invoke.MethodHandle;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashMap;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.NormalReflector;
import mirror.normalasm.api.NormalStringPool;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class JavaFixes {
    private static final MethodHandle SECURECLASSLOADER$PDCACHE$GETTER;
    private static final MethodHandle PERMISSION$NAME$SETTER;
    public static final JavaFixes INSTANCE;

    private JavaFixes() {
        this.run();
    }

    private void run() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            NormalStringPool.establishPool(1, 512, new String[0]);
            HashMap pdcache = SECURECLASSLOADER$PDCACHE$GETTER.invoke(Launch.classLoader);
            for (ProtectionDomain pd : pdcache.values()) {
                PermissionCollection pc = pd.getPermissions();
                if (pc == null) continue;
                Enumeration<Permission> perms = pc.elements();
                while (perms.hasMoreElements()) {
                    Permission perm = perms.nextElement();
                    PERMISSION$NAME$SETTER.invokeExact(perm, NormalStringPool.canonicalize(perm.getName()));
                }
            }
            NormalStringPool.purgePool(1);
        }
        catch (ConcurrentModificationException pdcache) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        NormalLogger.instance.info("Took {} to canonicalize Java's FilePermission caches.", (Object)stopwatch.stop());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.run();
    }

    static {
        MethodHandle secureClassLoader$pdcache$getter = null;
        MethodHandle permission$name$setter = null;
        try {
            secureClassLoader$pdcache$getter = NormalReflector.resolveFieldGetter(SecureClassLoader.class, "pdcache");
            permission$name$setter = NormalReflector.resolveFieldSetter(Permission.class, "name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SECURECLASSLOADER$PDCACHE$GETTER = secureClassLoader$pdcache$getter;
        PERMISSION$NAME$SETTER = permission$name$setter;
        INSTANCE = new JavaFixes();
    }
}

