/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.bakedquad;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import mirror.normalasm.NormalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NormalVertexDataPool {
    private static int deduplicatedCount = 0;
    private static int uniqueCount = 0;
    private static ObjectOpenCustomHashSet<int[]> POOL = new ObjectOpenCustomHashSet(8192, IntArrays.HASH_STRATEGY);

    public static int getSize() {
        return uniqueCount;
    }

    public static int getDeduplicatedCount() {
        return deduplicatedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] canonicalize(int[] vertexData) {
        if (POOL == null) {
            return vertexData;
        }
        ObjectOpenCustomHashSet<int[]> objectOpenCustomHashSet = POOL;
        synchronized (objectOpenCustomHashSet) {
            ++deduplicatedCount;
            return (int[])POOL.addOrGet((Object)vertexData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] canonicalize(int[] vertexData, BakedQuad quad) {
        if (POOL == null) {
            return vertexData;
        }
        ObjectOpenCustomHashSet<int[]> objectOpenCustomHashSet = POOL;
        synchronized (objectOpenCustomHashSet) {
            if (quad instanceof UnpackedBakedQuad) {
                return vertexData;
            }
            ++deduplicatedCount;
            return (int[])POOL.addOrGet((Object)vertexData);
        }
    }

    public static void invalidate() {
        if (POOL == null) {
            return;
        }
        uniqueCount = POOL.size();
        POOL = null;
        NormalLogger.instance.warn("Clearing NormalVertexDataPool");
    }

    @SubscribeEvent
    public static void onDebugList(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71474_y.field_74330_P) {
            ArrayList list = event.getLeft();
            list.add(String.format("%s%s%s: %s vertex data arrays processed. %s unique, %s deduplicated.", TextFormatting.AQUA, "<FermiumASM>", TextFormatting.RESET, deduplicatedCount, uniqueCount, deduplicatedCount - uniqueCount));
        }
    }
}

