/*
 * Decompiled with CFR 0.152.
 */
package collision.handlers;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="collisiondamage")
public class ModConfig {
    @Config.Comment(value={"Server Config"})
    @Config.Name(value="Server")
    public static final ServerConfig server = new ServerConfig();

    @Mod.EventBusSubscriber(modid="collisiondamage")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("collisiondamage")) {
                ConfigManager.sync((String)"collisiondamage", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ServerConfig {
        @Config.Comment(value={"How large the player's deceleration must be before they will begin taking damage. (Measured in meters per second per second"})
        @Config.Name(value="Acceleration Threshold")
        @Config.RangeDouble(min=5.0, max=100.0)
        public double accelerationThreshold = 12.0;
        @Config.Comment(value={"Multiplies the damage taken when over the threshold. Default 1.0x is 1 damage per 1m/s/s over threshold."})
        @Config.Name(value="Damage Multiplier")
        @Config.RangeDouble(min=0.0, max=100.0)
        public double damageMultiplier = 1.0;
        @Config.Comment(value={"Use damage type FLY_INTO_WALL? If false, will instead use FALL. (Set this to false if you want stuff like feather-falling to affect collision damage as well)"})
        @Config.Name(value="Damage Type Wall")
        public boolean damageTypeWall = true;
    }
}

