/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.camping;

import c4.corpsecomplex.common.modules.compatibility.camping.CampingModule;
import c4.corpsecomplex.common.modules.inventory.InventoryModule;
import c4.corpsecomplex.common.modules.inventory.capability.IDeathInventory;
import c4.corpsecomplex.common.modules.inventory.enchantment.EnchantmentModule;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathInventoryHandler;
import c4.corpsecomplex.common.modules.inventory.helpers.DeathStackHelper;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class CampingHandler
extends DeathInventoryHandler {
    private static final String MOD_ID = "camping";
    private NonNullList<ItemStack> campingSlots;

    public CampingHandler(EntityPlayer player) {
        super(player, MOD_ID);
        this.campingSlots = this.getCampingSlots(player);
    }

    @Override
    public void storeInventory() {
        NonNullList storedStacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        if (this.campingSlots == null) {
            return;
        }
        Random generator = new Random();
        for (int i = 0; i < this.campingSlots.size(); ++i) {
            int level;
            boolean store;
            ItemStack stack = (ItemStack)this.campingSlots.get(i);
            if (stack.func_190926_b()) continue;
            boolean essential = DeathStackHelper.isEssential(stack);
            boolean cursed = !essential && DeathStackHelper.isCursed(stack);
            boolean bl = store = this.checkToStore(0) && !cursed || essential;
            if (!store && EnchantmentModule.registerEnchant && (level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentModule.soulbound, (ItemStack)stack)) != 0) {
                store = essential = DeathStackHelper.handleSoulbound(stack, level);
                boolean bl2 = cursed = !essential && cursed;
            }
            if (cursed && InventoryModule.destroyCursed) {
                this.campingSlots.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            if (InventoryModule.dropLoss > 0.0 || InventoryModule.keptLoss > 0.0) {
                DeathStackHelper.loseDurability(this.player, stack, store);
            }
            if (stack.func_190926_b()) {
                return;
            }
            if (store && !essential && generator.nextDouble() < InventoryModule.randomDrop) {
                if (!(generator.nextDouble() < InventoryModule.randomDestroy)) continue;
                this.campingSlots.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            storedStacks.set(i, (Object)stack.func_77946_l());
            this.campingSlots.set(i, (Object)ItemStack.field_190927_a);
        }
        this.player.getEntityData().func_74782_a("campInv", (NBTBase)this.stacksToData(this.campingSlots));
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        tag.func_74782_a("campInv", (NBTBase)this.stacksToData((NonNullList<ItemStack>)storedStacks));
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    private NBTTagCompound stacksToData(NonNullList<ItemStack> stacks) {
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stacks.size(); ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("slotIndex", (byte)i);
            list.func_74742_a((NBTBase)((ItemStack)stacks.get(i)).func_77955_b(compound));
        }
        data.func_74782_a("items", (NBTBase)list);
        return data;
    }

    private NonNullList<ItemStack> getCampingSlots(EntityPlayer player) {
        NBTTagList taglist;
        NonNullList stacks = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        if (player.getEntityData().func_74764_b("campInv") && !(taglist = player.getEntityData().func_74775_l("campInv").func_150295_c("items", 10)).func_82582_d()) {
            for (int i = 0; i < taglist.func_74745_c(); ++i) {
                NBTTagCompound compound = taglist.func_150305_b(i);
                stacks.set((int)compound.func_74771_c("slotIndex"), (Object)new ItemStack(compound));
            }
        }
        return stacks;
    }

    @Override
    public boolean checkToStore(int slot) {
        return CampingModule.keepCamping;
    }

    @Override
    public void retrieveInventory(IDeathInventory oldDeathInventory) {
    }
}

