/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinInfo;
import org.spongepowered.asm.mixin.transformer.MixinPreProcessorStandard;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.mixin.transformer.throwables.InvalidInterfaceMixinException;
import org.spongepowered.asm.util.Bytecode;

class MixinPreProcessorInterface
extends MixinPreProcessorStandard {
    MixinPreProcessorInterface(MixinInfo mixin, MixinInfo.MixinClassNode classNode) {
        super(mixin, classNode);
    }

    @Override
    protected void prepareMethod(MixinInfo.MixinMethodNode mixinMethod, ClassInfo.Method method) {
        MixinEnvironment.CompatibilityLevel requiredLevelPrivate;
        boolean isPublic = Bytecode.hasFlag(mixinMethod, 1);
        MixinEnvironment.Feature injectorsInInterfaceMixins = MixinEnvironment.Feature.INJECTORS_IN_INTERFACE_MIXINS;
        MixinEnvironment.CompatibilityLevel currentLevel = MixinEnvironment.getCompatibilityLevel();
        MixinEnvironment.CompatibilityLevel requiredLevelSynthetic = MixinEnvironment.CompatibilityLevel.requiredFor(2);
        if (!isPublic && mixinMethod.isSynthetic()) {
            if (currentLevel.isLessThan(requiredLevelSynthetic)) {
                throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin contains a synthetic private method but compatibility level %s is required! Found %s in %s", new Object[]{requiredLevelSynthetic, method, this.mixin}));
            }
            return;
        }
        if (!isPublic && currentLevel.isLessThan(requiredLevelPrivate = MixinEnvironment.CompatibilityLevel.requiredFor(4))) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin contains a private method but compatibility level %s is required! Found %s in %s", new Object[]{requiredLevelPrivate, method, this.mixin}));
        }
        AnnotationNode injectorAnnotation = InjectionInfo.getInjectorAnnotation(this.mixin, mixinMethod);
        if (injectorAnnotation == null) {
            super.prepareMethod(mixinMethod, method);
            return;
        }
        if (injectorsInInterfaceMixins.isAvailable() && !injectorsInInterfaceMixins.isEnabled()) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin contains an injector but Feature.INJECTORS_IN_INTERFACE_MIXINS is disabled! Found %s in %s", method, this.mixin));
        }
        if (isPublic && !currentLevel.supports(4) && currentLevel.supports(2)) {
            Bytecode.setVisibility((MethodNode)mixinMethod, Bytecode.Visibility.PRIVATE);
            mixinMethod.access |= 0x1000;
        }
    }

    @Override
    protected boolean validateField(MixinTargetContext context, FieldNode field, AnnotationNode shadow) {
        if (!Bytecode.isStatic(field)) {
            throw new InvalidInterfaceMixinException((IMixinInfo)this.mixin, String.format("Interface mixin contains an instance field! Found %s in %s", field.name, this.mixin));
        }
        return super.validateField(context, field, shadow);
    }
}

