/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FermiumRegistryAPI {
    private static final Logger LOGGER = LogManager.getLogger((String)"FermiumRegistryAPI");
    private static HashMap<String, List<Supplier<Boolean>>> earlyMixins = new HashMap();
    private static HashMap<String, List<Supplier<Boolean>>> lateMixins = new HashMap();
    private static List<String> rejectMixins = new ArrayList<String>();

    public static void enqueueMixin(boolean late, String ... configurations) {
        for (String configuration : configurations) {
            FermiumRegistryAPI.enqueueMixin(late, configuration);
        }
    }

    public static void enqueueMixin(boolean late, String configuration) {
        FermiumRegistryAPI.enqueueMixin(late, configuration, true);
    }

    public static void enqueueMixin(boolean late, String configuration, boolean enabled) {
        FermiumRegistryAPI.enqueueMixin(late, configuration, () -> enabled);
    }

    public static void enqueueMixin(boolean late, String configuration, Supplier<Boolean> supplier) {
        if (configuration == null || configuration.trim().isEmpty()) {
            LOGGER.warn("FermiumRegistryAPI supplied null or empty configuration name during mixin enqueue, ignoring.");
            return;
        }
        if (supplier == null) {
            LOGGER.warn("FermiumRegistryAPI supplied null supplier for configuration \"" + configuration + "\" during mixin enqueue, ignoring.");
            return;
        }
        if (late) {
            LOGGER.info("FermiumRegistryAPI supplied \"" + configuration + "\" for late mixin enqueue, adding.");
            lateMixins.computeIfAbsent(configuration, k -> new ArrayList());
            lateMixins.get(configuration).add(supplier);
        } else {
            LOGGER.info("FermiumRegistryAPI supplied \"" + configuration + "\" for early mixin enqueue, adding.");
            earlyMixins.computeIfAbsent(configuration, k -> new ArrayList());
            earlyMixins.get(configuration).add(supplier);
        }
    }

    public static void removeMixin(String configuration) {
        if (configuration == null || configuration.trim().isEmpty()) {
            LOGGER.warn("FermiumRegistryAPI supplied null or empty configuration name for mixin removal, ignoring.");
            return;
        }
        LOGGER.info("FermiumRegistryAPI supplied \"" + configuration + "\" for mixin removal, adding.");
        rejectMixins.add(configuration);
    }

    public static HashMap<String, List<Supplier<Boolean>>> getEarlyMixins() {
        return earlyMixins;
    }

    public static HashMap<String, List<Supplier<Boolean>>> getLateMixins() {
        return lateMixins;
    }

    public static List<String> getRejectMixins() {
        return rejectMixins;
    }

    public static void clear() {
        earlyMixins = null;
        lateMixins = null;
        rejectMixins = null;
    }
}

