/*
 * Decompiled with CFR 0.152.
 */
package fermiumbooter;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import fermiumbooter.FermiumRegistryAPI;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.Name(value="FermiumBooter")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=990)
public class FermiumPlugin
implements IFMLLoadingPlugin {
    public static final Logger LOGGER = LogManager.getLogger((String)"FermiumBooter");

    public FermiumPlugin() {
        MixinBootstrap.init();
        MixinExtrasBootstrap.init();
        Mixins.addConfiguration("mixins.fermiumbooter.init.json");
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        for (Map.Entry<String, List<Supplier<Boolean>>> entry : FermiumRegistryAPI.getEarlyMixins().entrySet()) {
            if (FermiumRegistryAPI.getRejectMixins().contains(entry.getKey())) {
                LOGGER.warn("FermiumBooter received removal of \"" + entry.getKey() + "\" for early mixin application, rejecting.");
                continue;
            }
            Boolean enabled = null;
            for (Supplier<Boolean> supplier : entry.getValue()) {
                if (Boolean.TRUE.equals(enabled)) continue;
                Boolean supplied = supplier.get();
                if (supplied == null) {
                    LOGGER.warn("FermiumBooter received null value for individual supplier from \"" + entry.getKey() + "\" for early mixin application.");
                    continue;
                }
                enabled = supplied;
            }
            if (enabled == null) {
                LOGGER.warn("FermiumBooter received null value for suppliers from \"" + entry.getKey() + "\" for early mixin application, ignoring.");
                continue;
            }
            if (!enabled.booleanValue()) continue;
            LOGGER.info("FermiumBooter adding \"" + entry.getKey() + "\" for early mixin application.");
            Mixins.addConfiguration(entry.getKey());
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

