/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.ai.modifiers;

import funwayguy.epicsiegemod.ai.ESM_EntityAINearestAttackableTarget;
import funwayguy.epicsiegemod.ai.ESM_EntityAISpiderTarget;
import funwayguy.epicsiegemod.api.ITaskModifier;
import funwayguy.epicsiegemod.core.ESM;
import funwayguy.epicsiegemod.core.ESM_Settings;
import java.lang.reflect.Field;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;

public class ModifierNearestAttackable
implements ITaskModifier {
    private static Field f_targetClass;
    private static Field f_targetChance;
    private static Field f_shouldCheckSight;
    private static Field f_nearbyOnly;

    @Override
    public boolean isValid(EntityLiving entityLiving, EntityAIBase task) {
        if (entityLiving instanceof EntitySpider && task instanceof EntityAINearestAttackableTarget) {
            return true;
        }
        return task != null && task.getClass() == EntityAINearestAttackableTarget.class;
    }

    @Override
    public EntityAIBase getReplacement(EntityLiving host, EntityAIBase task) {
        if (ESM_Settings.neutralMobs) {
            return null;
        }
        boolean hasExisting = false;
        ESM_EntityAINearestAttackableTarget ai = null;
        for (EntityAITasks.EntityAITaskEntry t : host.field_70715_bh.field_75782_a) {
            if (!(t.field_75733_a instanceof ESM_EntityAINearestAttackableTarget)) continue;
            ai = (ESM_EntityAINearestAttackableTarget)t.field_75733_a;
            hasExisting = true;
            break;
        }
        try {
            Class tarClass = (Class)f_targetClass.get(task);
            int tarChance = f_targetChance.getInt(task);
            boolean sight = f_shouldCheckSight.getBoolean(task);
            boolean nearby = f_nearbyOnly.getBoolean(task);
            if (ai == null) {
                ai = host instanceof EntitySpider ? new ESM_EntityAISpiderTarget((EntitySpider)host) : new ESM_EntityAINearestAttackableTarget(host, tarChance, sight, nearby, null);
                if (ESM_Settings.Chaos) {
                    ai.addTarget(EntityLivingBase.class);
                }
            }
            if (!ESM_Settings.Chaos) {
                ai.addTarget(tarClass);
                if (ESM_Settings.VillagerTarget && EntityPlayer.class.isAssignableFrom(tarClass)) {
                    ai.addTarget(EntityVillager.class);
                }
            }
        }
        catch (Exception e) {
            ESM.logger.log(Level.ERROR, "Hook failed", (Throwable)e);
        }
        return hasExisting ? null : ai;
    }

    static {
        try {
            f_targetClass = EntityAINearestAttackableTarget.class.getDeclaredField("field_75307_b");
            f_targetChance = EntityAINearestAttackableTarget.class.getDeclaredField("field_75308_c");
            f_targetClass.setAccessible(true);
            f_targetChance.setAccessible(true);
            f_shouldCheckSight = EntityAITarget.class.getDeclaredField("field_75297_f");
            f_nearbyOnly = EntityAITarget.class.getDeclaredField("field_75303_a");
            f_shouldCheckSight.setAccessible(true);
            f_nearbyOnly.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                f_targetClass = EntityAINearestAttackableTarget.class.getDeclaredField("targetClass");
                f_targetChance = EntityAINearestAttackableTarget.class.getDeclaredField("targetChance");
                f_targetClass.setAccessible(true);
                f_targetChance.setAccessible(true);
                f_shouldCheckSight = EntityAITarget.class.getDeclaredField("shouldCheckSight");
                f_nearbyOnly = EntityAITarget.class.getDeclaredField("nearbyOnly");
                f_shouldCheckSight.setAccessible(true);
                f_nearbyOnly.setAccessible(true);
            }
            catch (Exception e2) {
                ESM.logger.log(Level.ERROR, "Unable to enable access to AI targetting variables", (Throwable)e2);
            }
        }
    }
}

