/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.output;

import com.google.gson.annotations.JsonAdapter;
import com.teamacronymcoders.base.json.deserializer.BlockPosDeserializer;
import com.teamacronymcoders.base.json.deserializer.BlockStateDeserializer;
import com.teamacronymcoders.base.json.deserializer.NBTDeserializer;
import com.teamacronymcoders.base.recipesystem.RecipeContainer;
import com.teamacronymcoders.base.recipesystem.output.IOutput;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockStateOutput
implements IOutput {
    @JsonAdapter(value=BlockStateDeserializer.class)
    private final IBlockState blockState;
    @JsonAdapter(value=BlockPosDeserializer.class)
    private final BlockPos offset;
    @JsonAdapter(value=NBTDeserializer.class)
    private final NBTTagCompound tileEntityNBT;

    public BlockStateOutput(IBlockState blockState, BlockPos offset, NBTTagCompound tileEntityNBT) {
        this.blockState = blockState;
        this.offset = offset;
        this.tileEntityNBT = tileEntityNBT;
    }

    @Override
    public boolean canOutput(RecipeContainer recipeContainer) {
        return true;
    }

    @Override
    public void output(RecipeContainer recipeContainer) {
        TileEntity tileEntity;
        BlockPos pos = this.offset != null ? recipeContainer.getPos().func_177971_a((Vec3i)this.offset) : recipeContainer.getPos();
        recipeContainer.getWorld().func_180501_a(pos, this.blockState, 3);
        if (this.tileEntityNBT != null && !this.tileEntityNBT.func_82582_d() && (tileEntity = recipeContainer.getWorld().func_175625_s(pos)) != null) {
            NBTTagCompound currentNBT = tileEntity.func_189515_b(new NBTTagCompound());
            NBTTagCompound originalNBT = currentNBT.func_74737_b();
            currentNBT.func_179237_a(this.tileEntityNBT.func_74737_b());
            currentNBT.func_74768_a("x", pos.func_177958_n());
            currentNBT.func_74768_a("y", pos.func_177956_o());
            currentNBT.func_74768_a("z", pos.func_177952_p());
            if (!currentNBT.equals((Object)originalNBT)) {
                tileEntity.func_145839_a(currentNBT);
                tileEntity.func_70296_d();
            }
        }
    }
}

