/*
 * Decompiled with CFR 0.152.
 */
package shieldbreak.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;
import shieldbreak.core.ShieldBreak;
import shieldbreak.util.PotionEntry;

@Config(modid="shieldbreak")
public class ModConfig {
    @Config.Comment(value={"Server Config"})
    @Config.Name(value="Server")
    @Config.LangKey(value="config.shieldbreak.server")
    public static final ServerConfig server = new ServerConfig();

    @Mod.EventBusSubscriber(modid="shieldbreak")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("shieldbreak")) {
                server.resetEffectCache();
                ConfigManager.sync((String)"shieldbreak", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class ServerConfig {
        private List<PotionEntry> attackerParry = null;
        private List<PotionEntry> defenderParry = null;
        private List<PotionEntry> attackerBreak = null;
        private List<PotionEntry> defenderBreak = null;
        @Config.Comment(value={"Minimum amount of damage any shield will withstand before chance of cooldown."})
        @Config.Name(value="Damage Minimum Threshold")
        @Config.LangKey(value="config.shieldbreak.server.damageMinimumThreshold")
        public float damageMinimumThreshold = 1.0f;
        @Config.Comment(value={"Maximum amount of damage any shield will withstand before chance of cooldown."})
        @Config.Name(value="Damage Maximum Threshold")
        @Config.LangKey(value="config.shieldbreak.server.damageMaximumThreshold")
        public float damageMaximumThreshold = 20.0f;
        @Config.Comment(value={"Scaling for how much damage a shield will withstand before chance of cooldown based on max durability. (Durability/This = Damage)"})
        @Config.Name(value="Damage Durability Scaling")
        @Config.LangKey(value="config.shieldbreak.server.damageDurabilityScaling")
        public float damageDurabilityScaling = 100.0f;
        @Config.Comment(value={"Minimum amount of cooldown ticks a shield break will cause."})
        @Config.Name(value="Cooldown Minimum Ticks")
        @Config.LangKey(value="config.shieldbreak.server.cooldownTicksMinimum")
        public int cooldownTicksMinimum = 10;
        @Config.Comment(value={"Maximum amount of cooldown ticks a shield break will cause."})
        @Config.Name(value="Cooldown Maximum Ticks")
        @Config.LangKey(value="config.shieldbreak.server.cooldownTicksMaximum")
        public int cooldownTicksMaximum = 200;
        @Config.Comment(value={"Multiplier for cooldown ticks per point of damage."})
        @Config.Name(value="Cooldown Ticks Scaling")
        @Config.LangKey(value="config.shieldbreak.server.cooldownTicksScaling")
        public float cooldownTicksScaling = 10.0f;
        @Config.Comment(value={"Range for how long the shield can be held up and still parry the attack. (Counted after the initial shield delay, if any)"})
        @Config.Name(value="Parry Tick Range")
        @Config.LangKey(value="config.shieldbreak.server.parryTickRange")
        public int parryTickRange = 10;
        @Config.Comment(value={"How much durability a shield should have for the purpose of scaling if it's max durability is 0."})
        @Config.Name(value="Shield Durability Fallback")
        @Config.LangKey(value="config.shieldbreak.server.unbreakableShieldDurability")
        public int unbreakableShieldDurability = 3000;
        @Config.Comment(value={"How many ticks should it take when raising a shield for it to become active."})
        @Config.Name(value="Shield Raise Tick Delay")
        @Config.LangKey(value="config.shieldbreak.server.shieldRaiseTickDelay")
        public int shieldRaiseTickDelay = 5;
        @Config.Comment(value={"Base chance for a weapon that can break shields to ignore shield protection and cause a cooldown. (Ex. Axe and Halberd)"})
        @Config.Name(value="Shield Bypass Chance")
        @Config.LangKey(value="config.shieldbreak.server.shieldBypassChance")
        public float shieldBypassChance = 0.25f;
        @Config.Comment(value={"How long should the cooldown be if a weapon that can break shields bypasses the shield. (Ex. Axe and Halberd)"})
        @Config.Name(value="Shield Bypass Cooldown")
        @Config.LangKey(value="config.shieldbreak.server.shieldBypassCooldown")
        public int shieldBypassCooldown = 100;
        @Config.Comment(value={"Always reset active hand after shield hit? (Fixes exploit with using handheld gui's to attack while shielding)"})
        @Config.Name(value="Always Reset Active Hand")
        @Config.LangKey(value="config.shieldbreak.server.alwaysResetActiveHand")
        public boolean alwaysResetActiveHand = true;
        @Config.Comment(value={"Potion Effects to apply to an attacker on a parry. (Potion,Duration,Amplifier)"})
        @Config.Name(value="Potion Effect Attacker Parry")
        @Config.LangKey(value="config.shieldbreak.server.potionEffectAttackerParry")
        public String[] potionEffectAttackerParry = new String[]{""};
        @Config.Comment(value={"Potion Effects to apply to a defender on a parry. (Potion,Duration,Amplifier)"})
        @Config.Name(value="Potion Effect Defender Parry")
        @Config.LangKey(value="config.shieldbreak.server.potionEffectDefenderParry")
        public String[] potionEffectDefenderParry = new String[]{""};
        @Config.Comment(value={"Potion Effects to apply to an attacker on a break. (Potion,Duration,Amplifier)"})
        @Config.Name(value="Potion Effect Attacker Break")
        @Config.LangKey(value="config.shieldbreak.server.potionEffectAttackerBreak")
        public String[] potionEffectAttackerBreak = new String[]{""};
        @Config.Comment(value={"Potion Effects to apply to a defender on a break. (Potion,Duration,Amplifier)"})
        @Config.Name(value="Potion Effect Defender Break")
        @Config.LangKey(value="config.shieldbreak.server.potionEffectDefenderBreak")
        public String[] potionEffectDefenderBreak = new String[]{""};
        @Config.Comment(value={"Knockback power on parry."})
        @Config.Name(value="Knockback Parry")
        @Config.LangKey(value="config.shieldbreak.server.knockbackParry")
        public float knockbackParry = 1.0f;
        @Config.Comment(value={"Knockback power on normal block."})
        @Config.Name(value="Knockback Normal")
        @Config.LangKey(value="config.shieldbreak.server.knockbackNormal")
        public float knockbackNormal = 0.5f;
        @Config.Comment(value={"Knockback power on break."})
        @Config.Name(value="Knockback Break")
        @Config.LangKey(value="config.shieldbreak.server.knockbackBreak")
        public float knockbackBreak = 0.25f;

        public void resetEffectCache() {
            this.attackerParry = null;
            this.attackerBreak = null;
            this.defenderParry = null;
            this.defenderBreak = null;
        }

        @Nullable
        public List<PotionEntry> getEffectAttackerParry() {
            if (this.attackerParry != null) {
                return this.attackerParry;
            }
            if (this.potionEffectAttackerParry.length > 0) {
                this.attackerParry = this.getPotionEffectFromString(this.potionEffectAttackerParry);
                return this.attackerParry;
            }
            return null;
        }

        @Nullable
        public List<PotionEntry> getEffectDefenderParry() {
            if (this.defenderParry != null) {
                return this.defenderParry;
            }
            if (this.potionEffectDefenderParry.length > 0) {
                this.defenderParry = this.getPotionEffectFromString(this.potionEffectDefenderParry);
                return this.defenderParry;
            }
            return null;
        }

        @Nullable
        public List<PotionEntry> getEffectAttackerBreak() {
            if (this.attackerBreak != null) {
                return this.attackerBreak;
            }
            if (this.potionEffectAttackerBreak.length > 0) {
                this.attackerBreak = this.getPotionEffectFromString(this.potionEffectAttackerBreak);
                return this.attackerBreak;
            }
            return null;
        }

        @Nullable
        public List<PotionEntry> getEffectDefenderBreak() {
            if (this.defenderBreak != null) {
                return this.defenderBreak;
            }
            if (this.potionEffectDefenderBreak.length > 0) {
                this.defenderBreak = this.getPotionEffectFromString(this.potionEffectDefenderBreak);
                return this.defenderBreak;
            }
            return null;
        }

        @Nullable
        private List<PotionEntry> getPotionEffectFromString(String[] entryList) {
            try {
                ArrayList<PotionEntry> returnable = new ArrayList<PotionEntry>();
                for (String entryUnclean : entryList) {
                    if (entryUnclean.isEmpty()) continue;
                    String[] entry = this.cleanEntry(entryUnclean);
                    Potion potion = Potion.func_180142_b((String)entry[0]);
                    if (potion == null) {
                        ShieldBreak.logger.log(Level.WARN, "Invalid potion name: " + entry[0]);
                        continue;
                    }
                    int duration = Integer.parseInt(entry[1]);
                    int amplifier = Integer.parseInt(entry[2]);
                    returnable.add(new PotionEntry(potion, duration, amplifier));
                }
                return returnable.isEmpty() ? null : returnable;
            }
            catch (Exception ex) {
                ShieldBreak.logger.log(Level.WARN, "Failed to parse config entry: " + ex);
                return null;
            }
        }

        private String[] cleanEntry(String entry) {
            return (String[])Arrays.stream(entry.split(",")).map(String::trim).toArray(String[]::new);
        }
    }
}

