/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.templates;

import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class Cover {
    public ItemStack stack;
    public IBlockState state;
    public boolean opaque;

    public boolean interact(BaseTileEntity tile, EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (this.stack != null) {
            if (player.func_184812_l_() && item.func_190926_b() && player.func_70093_af()) {
                return this.hit(tile, player);
            }
            return false;
        }
        hand = EnumHand.OFF_HAND;
        item = player.func_184586_b(hand);
        if (player.func_70093_af() || item.func_190926_b() || !(item.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        ItemBlock ib = (ItemBlock)item.func_77973_b();
        int m = ib.func_77647_b(item.func_77960_j());
        IBlockState state = ib.func_179223_d().getStateForPlacement(world, pos, s, X, Y, Z, m, (EntityLivingBase)player, hand);
        if (!Cover.isBlockValid(tile, state)) {
            return false;
        }
        this.stack = ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1);
        this.state = state;
        this.opaque = state.func_185914_p();
        if (!player.func_184812_l_()) {
            item.func_190917_f(-1);
            player.func_184611_a(hand, item);
        }
        world.func_175722_b(pos, tile.func_145838_q(), true);
        if (state.func_185906_d() > 0 || state.getLightOpacity((IBlockAccess)world, pos) > 0) {
            world.func_175664_x(pos);
        }
        tile.markDirty(3);
        return true;
    }

    public boolean hit(BaseTileEntity tile, EntityPlayer player) {
        if (this.stack == null) {
            return false;
        }
        if (!player.func_184812_l_()) {
            ItemFluidUtil.dropStack(this.stack, (Entity)player);
        }
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        boolean checkLight = this.state.func_185906_d() > 0 || this.state.getLightOpacity((IBlockAccess)world, pos) > 0;
        this.stack = null;
        this.state = null;
        this.opaque = false;
        world.func_175722_b(pos, tile.func_145838_q(), true);
        if (checkLight) {
            world.func_175664_x(pos);
        }
        tile.markDirty(3);
        return true;
    }

    public static boolean isBlockValid(@Nullable TileEntity tile, IBlockState state) {
        if (state.func_177230_c().hasTileEntity(state)) {
            return false;
        }
        return state.func_185904_a().func_76230_c();
    }

    public void readNBT(NBTTagCompound nbt, String k, @Nullable TileEntity packetReceiver) {
        Block block;
        this.stack = nbt.func_150297_b(k + "I", 10) ? new ItemStack(nbt.func_74775_l(k + "I")) : null;
        String name = nbt.func_74779_i(k + "B");
        this.state = null;
        if (!name.isEmpty() && (block = Block.func_149684_b((String)name)) != null) {
            this.state = block.func_176203_a(nbt.func_74771_c(k + "m") & 0xF);
            if (!Cover.isBlockValid(null, this.state)) {
                this.state = null;
            }
        }
        boolean bl = this.opaque = this.state != null && this.state.func_185914_p();
        if (packetReceiver != null) {
            packetReceiver.func_145831_w().func_175664_x(packetReceiver.func_174877_v());
        }
    }

    public void writeNBT(NBTTagCompound nbt, String k, boolean packetSync) {
        if (!packetSync && this.stack != null) {
            nbt.func_74782_a(k + "I", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        }
        if (this.state != null) {
            Block block = this.state.func_177230_c();
            nbt.func_74778_a(k + "B", block.getRegistryName().toString());
            nbt.func_74774_a(k + "m", (byte)block.func_176201_c(this.state));
        }
    }

    public <M> M module() {
        return (M)this.state;
    }
}

