/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import java.util.Random;

public class Number
implements IOperand {
    public static final Number TRUE = new Number(1.0).onCopy();
    public static final Number FALSE = new Number(0.0).onCopy();
    public static final Number NAN = new Number(Double.NaN).onCopy();
    private static final Random RANDOM = new Random();
    private boolean copied;
    public double value;

    public Number(double value) {
        this.value = value;
    }

    private Number of(double value) {
        if (this.copied) {
            return new Number(value);
        }
        this.value = value;
        return this;
    }

    @Override
    public Number onCopy() {
        this.copied = true;
        return this;
    }

    @Override
    public boolean asBool() {
        double v = this.value;
        return v >= 1.0 || v > 0.0 && v > RANDOM.nextDouble();
    }

    @Override
    public int asIndex() {
        return (int)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    private double asNumBool() {
        double v = this.value;
        return v >= 1.0 ? 1.0 : (v <= 0.0 ? 0.0 : v);
    }

    @Override
    public boolean isError() {
        return Double.isNaN(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public IOperand addR(IOperand x) {
        return x instanceof Number ? this.of(this.value + ((Number)x).value) : x.addL(this);
    }

    @Override
    public IOperand subR(IOperand x) {
        return x instanceof Number ? this.of(this.value - ((Number)x).value) : x.subL(this);
    }

    @Override
    public IOperand mulR(IOperand x) {
        return x instanceof Number ? this.of(this.value * ((Number)x).value) : x.mulL(this);
    }

    @Override
    public IOperand divR(IOperand x) {
        return x instanceof Number ? this.of(this.value / ((Number)x).value) : x.divL(this);
    }

    @Override
    public IOperand modR(IOperand x) {
        return x instanceof Number ? this.of(this.value % ((Number)x).value) : x.modL(this);
    }

    @Override
    public IOperand powR(IOperand x) {
        return x instanceof Number ? this.of(Math.pow(this.value, ((Number)x).value)) : x.powL(this);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Number && ((Number)obj).value == this.value;
    }

    @Override
    public IOperand grR(IOperand x) {
        if (x instanceof Number) {
            double v = ((Number)x).value;
            return this.value > v ? TRUE : FALSE;
        }
        return x.grL(this);
    }

    @Override
    public IOperand grL(IOperand x) {
        if (x instanceof Number) {
            double v = ((Number)x).value;
            return this.value < v ? TRUE : FALSE;
        }
        return IOperand.super.grL(x);
    }

    @Override
    public IOperand nlsR(IOperand x) {
        if (x instanceof Number) {
            double v = ((Number)x).value;
            return this.value >= v ? TRUE : FALSE;
        }
        return x.nlsL(this);
    }

    @Override
    public IOperand nlsL(IOperand x) {
        if (x instanceof Number) {
            double v = ((Number)x).value;
            return this.value <= v ? TRUE : FALSE;
        }
        return IOperand.super.nlsL(x);
    }

    @Override
    public IOperand and(IOperand x) {
        try {
            double b = x instanceof Number ? ((Number)x).asNumBool() : (x.asBool() ? 1.0 : 0.0);
            double a = this.asNumBool();
            return this.of(a * b);
        }
        catch (Error e) {
            return e.reset(this.value + " & ERROR");
        }
    }

    @Override
    public IOperand or(IOperand x) {
        try {
            double b = x instanceof Number ? ((Number)x).asNumBool() : (x.asBool() ? 1.0 : 0.0);
            double a = this.asNumBool();
            return this.of(a + b - a * b);
        }
        catch (Error e) {
            return e.reset(this.value + " | ERROR");
        }
    }

    @Override
    public IOperand nand(IOperand x) {
        try {
            double b = x instanceof Number ? ((Number)x).asNumBool() : (x.asBool() ? 1.0 : 0.0);
            double a = this.asNumBool();
            return this.of(1.0 - a * b);
        }
        catch (Error e) {
            return e.reset(this.value + " ~& ERROR");
        }
    }

    @Override
    public IOperand nor(IOperand x) {
        try {
            double b = x instanceof Number ? ((Number)x).asNumBool() : (x.asBool() ? 1.0 : 0.0);
            double a = this.asNumBool();
            return this.of((1.0 - a) * (1.0 - b));
        }
        catch (Error e) {
            return e.reset(this.value + " ~| ERROR");
        }
    }

    @Override
    public IOperand xor(IOperand x) {
        try {
            double b = x instanceof Number ? ((Number)x).asNumBool() : (x.asBool() ? 1.0 : 0.0);
            double a = this.asNumBool();
            return this.of(a + b - 2.0 * a * b);
        }
        catch (Error e) {
            return e.reset(this.value + " ^ ERROR");
        }
    }

    @Override
    public IOperand xnor(IOperand x) {
        try {
            double b = x instanceof Number ? 1.0 - ((Number)x).asNumBool() : (x.asBool() ? 0.0 : 1.0);
            double a = this.asNumBool();
            return this.of(a + b - 2.0 * a * b);
        }
        catch (Error e) {
            return e.reset(this.value + " ~^ ERROR");
        }
    }

    @Override
    public IOperand not() {
        return this.of(1.0 - this.value);
    }

    @Override
    public IOperand neg() {
        return this.of(-this.value);
    }

    @Override
    public IOperand inv() {
        return this.of(1.0 / this.value);
    }

    @Override
    public IOperand len() {
        return this.of(Math.floor(this.value));
    }

    @Override
    public IOperand.OperandIterator iterator() {
        return new IntIterator((int)Math.ceil(this.value));
    }

    @Override
    public Object value() {
        return this.value;
    }

    static class IntIterator
    implements IOperand.OperandIterator {
        final int max;
        int cur;

        public IntIterator(int max) {
            this.max = max;
            this.cur = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.max;
        }

        @Override
        public Number next() {
            return new Number(this.cur++);
        }

        @Override
        public void set(IOperand e) {
        }

        @Override
        public void reset() {
            this.cur = 0;
        }

        @Override
        public Object value() {
            return this;
        }
    }
}

