/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.Number;
import java.util.Iterator;

public interface IOperand {
    public static final OperandIterator NULL_IT = new OperandIterator(){

        @Override
        public IOperand next() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void set(IOperand obj) {
        }

        @Override
        public Object value() {
            return null;
        }
    };

    default public IOperand onCopy() {
        return this;
    }

    public boolean asBool() throws Error;

    default public int asIndex() {
        return -1;
    }

    default public double asDouble() {
        return Double.NaN;
    }

    public Object value();

    default public boolean isError() {
        return false;
    }

    default public IOperand addR(IOperand x) {
        return x.addL(this);
    }

    default public IOperand addL(IOperand x) {
        return new Error("undefined " + x + " + " + this);
    }

    default public IOperand subR(IOperand x) {
        return x.subL(this);
    }

    default public IOperand subL(IOperand x) {
        return new Error("undefined " + x + " - " + this);
    }

    default public IOperand mulR(IOperand x) {
        return x.mulL(this);
    }

    default public IOperand mulL(IOperand x) {
        return new Error("undefined " + x + " * " + this);
    }

    default public IOperand divR(IOperand x) {
        return x.divL(this);
    }

    default public IOperand divL(IOperand x) {
        return new Error("undefined " + x + " / " + this);
    }

    default public IOperand modR(IOperand x) {
        return x.modL(this);
    }

    default public IOperand modL(IOperand x) {
        return new Error("undefined " + x + " % " + this);
    }

    default public IOperand powR(IOperand x) {
        return x.powL(this);
    }

    default public IOperand powL(IOperand x) {
        return new Error("undefined " + x + " % " + this);
    }

    default public IOperand grR(IOperand x) {
        return x.grL(this);
    }

    default public IOperand grL(IOperand x) {
        return Number.FALSE;
    }

    default public IOperand nlsR(IOperand x) {
        return x.nlsL(this);
    }

    default public IOperand nlsL(IOperand x) {
        return this.equals(x) ? Number.TRUE : Number.FALSE;
    }

    default public IOperand and(IOperand x) {
        try {
            return this.asBool() && x.asBool() ? Number.TRUE : Number.FALSE;
        }
        catch (Error e) {
            return e.reset(this + " & " + x);
        }
    }

    default public IOperand or(IOperand x) {
        try {
            return this.asBool() || x.asBool() ? Number.TRUE : Number.FALSE;
        }
        catch (Error e) {
            return e.reset(this + " | " + x);
        }
    }

    default public IOperand nand(IOperand x) {
        try {
            return this.asBool() && x.asBool() ? Number.FALSE : Number.TRUE;
        }
        catch (Error e) {
            return e.reset(this + " ~& " + x);
        }
    }

    default public IOperand nor(IOperand x) {
        try {
            return this.asBool() || x.asBool() ? Number.FALSE : Number.TRUE;
        }
        catch (Error e) {
            return e.reset(this + " ~| " + x);
        }
    }

    default public IOperand xor(IOperand x) {
        try {
            return this.asBool() ^ x.asBool() ? Number.TRUE : Number.FALSE;
        }
        catch (Error e) {
            return e.reset(this + " ^ " + x);
        }
    }

    default public IOperand xnor(IOperand x) {
        try {
            return this.asBool() && x.asBool() ? Number.FALSE : Number.TRUE;
        }
        catch (Error e) {
            return e.reset(this + " ~^ " + x);
        }
    }

    default public IOperand neg() {
        return new Error("undefined -" + this);
    }

    default public IOperand inv() {
        return new Error("undefined /" + this);
    }

    default public IOperand not() {
        try {
            return this.asBool() ? Number.FALSE : Number.TRUE;
        }
        catch (Error e) {
            return new Error("undefined ~" + this);
        }
    }

    default public IOperand len() {
        return new Error("undefined #" + this);
    }

    default public IOperand get(IOperand idx) {
        return new Error("undefined " + this + ":" + idx);
    }

    default public void put(IOperand idx, IOperand val) {
    }

    default public OperandIterator iterator() throws Error {
        return NULL_IT;
    }

    default public boolean equals(IOperand obj) {
        Object o1 = this.value();
        Object o2 = obj.value();
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static interface OperandIterator
    extends Iterator<IOperand>,
    IOperand {
        @Override
        default public boolean asBool() {
            return this.hasNext();
        }

        public void set(IOperand var1);

        default public void reset() {
        }
    }
}

