/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.effect;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.config.EntityConfig;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.dsurround.registry.effect.EntityEffectInfo;
import org.orecruncher.dsurround.registry.effect.theme.GloamwoodTheme;
import org.orecruncher.dsurround.registry.effect.theme.ThemeInfo;

@SideOnly(value=Side.CLIENT)
public class EffectRegistry
extends Registry {
    public static final EntityEffectInfo DEFAULT = new EntityEffectInfo();
    public static final ResourceLocation DEFAULT_THEME = new ResourceLocation("dsurround", "default");
    private static final ThemeInfo DEFAULT_THEME_INFO = new ThemeInfo();
    protected final Map<Class<? extends Entity>, EntityEffectInfo> effects = new Reference2ObjectOpenHashMap();
    protected EntityEffectInfo playerEffects = DEFAULT;
    protected final Map<ResourceLocation, ThemeInfo> themes = new Object2ObjectOpenHashMap();
    protected ThemeInfo activeTheme = DEFAULT_THEME_INFO;

    public EffectRegistry() {
        super("Effects Registry");
    }

    @Override
    protected void preInit() {
        this.playerEffects = DEFAULT;
        this.effects.clear();
        this.themes.clear();
        this.activeTheme = DEFAULT_THEME_INFO;
        this.themes.put(DEFAULT_THEME, DEFAULT_THEME_INFO);
        this.themes.put(new ResourceLocation("dsurround", "gloamwood"), new GloamwoodTheme());
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        for (Map.Entry<String, EntityConfig> e : cfg.entities.entrySet()) {
            String entityName = e.getKey();
            EntityConfig entityEffects = e.getValue();
            if ("minecraft:player".equals(entityName)) {
                this.playerEffects = new EntityEffectInfo(entityEffects);
                continue;
            }
            Class clazz = EntityList.func_192839_a((String)entityName);
            if (clazz != null) {
                this.effects.put(clazz, new EntityEffectInfo(entityEffects));
                continue;
            }
            ModBase.log().warn("Unrecognized resource name for entity: %s", new Object[]{entityName});
        }
    }

    @Override
    protected void postInit() {
        block0: for (ResourceLocation r : EntityList.func_180124_b()) {
            Class clazz = EntityList.getClass((ResourceLocation)r);
            if (clazz != null) {
                if (this.effects.containsKey(clazz)) continue;
                for (Map.Entry<Class<? extends Entity>, EntityEffectInfo> e : this.effects.entrySet()) {
                    if (!e.getKey().isAssignableFrom(clazz)) continue;
                    this.effects.put(clazz, e.getValue());
                    continue block0;
                }
                continue;
            }
            ModBase.log().debug("Forge reported entity %s but not found in it's own registry!", new Object[]{r.toString()});
        }
    }

    @Override
    protected void complete() {
        if (ModOptions.logging.enableDebugLogging) {
            ModBase.log().info("Entity Effect Configuration", new Object[0]);
            ModBase.log().info("===========================", new Object[0]);
            for (ResourceLocation r : EntityList.func_180124_b()) {
                Class clazz = EntityList.getClass((ResourceLocation)r);
                if (clazz == null) continue;
                EntityEffectInfo info = this.effects.getOrDefault(clazz, DEFAULT);
                ModBase.log().info("%s = %s", new Object[]{r.toString(), info.toString()});
            }
        }
    }

    @Nonnull
    public EntityEffectInfo getEffects(@Nonnull Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.playerEffects;
        }
        return this.effects.getOrDefault(entity.getClass(), DEFAULT);
    }

    @Nonnull
    public ThemeInfo setTheme(@Nonnull ResourceLocation theme) {
        this.activeTheme = this.themes.getOrDefault(theme, DEFAULT_THEME_INFO);
        return this.activeTheme;
    }
}

