/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.blockstate;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.lib.BlockNameUtil;

@SideOnly(value=Side.CLIENT)
public final class BlockStateMatcher {
    private static final Reference2ObjectOpenHashMap<IProperty<?>, Object> EMPTY = new Reference2ObjectOpenHashMap(0);
    public static final BlockStateMatcher AIR = BlockStateMatcher.create(Blocks.field_150350_a.func_176223_P());
    protected final Block block;
    protected final Reference2ObjectOpenHashMap<IProperty<?>, Object> props;

    protected BlockStateMatcher(@Nonnull IBlockState state) {
        this.block = state.func_177230_c();
        this.props = this.getPropsFromState(state);
    }

    protected BlockStateMatcher(@Nonnull Block block) {
        this(block, EMPTY);
    }

    protected BlockStateMatcher(@Nonnull Block block, @Nonnull Reference2ObjectOpenHashMap<IProperty<?>, Object> props) {
        this.block = block;
        this.props = props;
    }

    @Nonnull
    public Block getBlock() {
        return this.block;
    }

    @Nonnull
    public List<IBlockState> asBlockStates() {
        return this.block.func_176194_O().func_177619_a().stream().filter(this::matchProps).collect(Collectors.toList());
    }

    protected boolean matchProps(@Nonnull IBlockState state) {
        if (this.props.isEmpty()) {
            return true;
        }
        for (Reference2ObjectMap.Entry entry : this.props.reference2ObjectEntrySet()) {
            Comparable result = state.func_177229_b((IProperty)entry.getKey());
            if (entry.getValue().equals(result)) continue;
            return false;
        }
        return true;
    }

    public boolean hasSubtypes() {
        return this.block.func_176194_O().func_177619_a().size() > 1;
    }

    public int hashCode() {
        return this.block.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockStateMatcher) {
            BlockStateMatcher m = (BlockStateMatcher)obj;
            if (this.block != m.block) {
                return false;
            }
            if (this.props.isEmpty() && m.props.isEmpty()) {
                return true;
            }
            if (this.props.size() < m.props.size()) {
                return false;
            }
            for (Reference2ObjectMap.Entry entry : m.props.reference2ObjectEntrySet()) {
                Object v = this.props.get(entry.getKey());
                if (v != null && v.equals(entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected Reference2ObjectOpenHashMap<IProperty<?>, Object> getPropsFromState(@Nonnull IBlockState state) {
        Reference2ObjectOpenHashMap result = new Reference2ObjectOpenHashMap(1);
        for (IProperty prop : state.func_177227_a()) {
            Comparable o = state.func_177229_b(prop);
            result.put((Object)prop, (Object)o);
        }
        return result.size() == 0 ? EMPTY : result;
    }

    @Nonnull
    public static BlockStateMatcher asGeneric(@Nonnull IBlockState state) {
        return new BlockStateMatcher(state.func_177230_c());
    }

    @Nonnull
    public static BlockStateMatcher create(@Nonnull IBlockState state) {
        return new BlockStateMatcher(state);
    }

    @Nullable
    public static BlockStateMatcher create(@Nonnull String blockId) {
        return BlockStateMatcher.create(BlockNameUtil.parseBlockName((String)blockId));
    }

    @Nullable
    public static BlockStateMatcher create(@Nullable BlockNameUtil.NameResult result) {
        if (result != null) {
            Block block = result.getBlock();
            if (block != null) {
                IBlockState defaultState = block.func_176223_P();
                BlockStateContainer container = block.func_176194_O();
                if (container.func_177619_a().size() == 1) {
                    return new BlockStateMatcher(defaultState);
                }
                if (!result.hasProperties()) {
                    return new BlockStateMatcher(block);
                }
                Map properties = result.getProperties();
                if (properties == null) {
                    properties = ImmutableMap.of();
                }
                Reference2ObjectOpenHashMap props = new Reference2ObjectOpenHashMap(properties.size());
                for (Map.Entry entry : properties.entrySet()) {
                    String s = (String)entry.getKey();
                    IProperty prop = container.func_185920_a(s);
                    if (prop != null) {
                        Optional optional = prop.func_185929_b((String)entry.getValue());
                        if (optional.isPresent()) {
                            props.put((Object)prop, optional.get());
                            continue;
                        }
                        String allowed = BlockStateMatcher.getAllowedValues(block, s);
                        ModBase.log().warn("Property value '%s' for property '%s' not found for block '%s'", new Object[]{entry.getValue(), s, result.getBlockName()});
                        ModBase.log().warn("Allowed values: %s", new Object[]{allowed});
                        continue;
                    }
                    ModBase.log().warn("Property %s not found for block %s", new Object[]{s, result.getBlockName()});
                }
                if (props.size() > 0) {
                    return new BlockStateMatcher(defaultState.func_177230_c(), props);
                }
                return new BlockStateMatcher(defaultState);
            }
            ModBase.log().warn("Unable to locate block '%s' in the Forge registry", new Object[]{result.getBlockName()});
        }
        return null;
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Block.field_149771_c.func_177774_c((Object)this.block));
        if (!this.props.isEmpty()) {
            String txt = this.props.reference2ObjectEntrySet().stream().map(e -> ((IProperty)e.getKey()).func_177701_a() + "=" + BlockStateMatcher.getValue(this.block, ((IProperty)e.getKey()).func_177701_a(), e.getValue())).collect(Collectors.joining(","));
            builder.append('[').append(txt).append(']');
        }
        return builder.toString();
    }

    protected static <T extends Comparable<T>> String getValue(@Nonnull Block block, @Nonnull String propName, @Nonnull Object val) {
        BlockStateContainer container = block.func_176194_O();
        IProperty prop = container.func_185920_a(propName);
        return prop != null ? prop.func_177702_a((Comparable)val) : null;
    }

    protected static <T extends Comparable<T>> String getAllowedValues(Block block, String propName) {
        BlockStateContainer container = block.func_176194_O();
        IProperty prop = container.func_185920_a(propName);
        ArrayList<String> result = new ArrayList<String>();
        if (prop != null) {
            for (Comparable v : prop.func_177700_c()) {
                result.add(prop.func_177702_a(v));
            }
        }
        return String.join((CharSequence)",", result);
    }
}

