/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.footsteps.ConfigOptions;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.IOptions;
import org.orecruncher.dsurround.registry.acoustics.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class RainSplashAcoustic
implements IAcoustic {
    protected final IAcoustic[] acoustics;

    public RainSplashAcoustic(@Nonnull IAcoustic[] acoustics) {
        this.acoustics = acoustics;
    }

    @Override
    @Nonnull
    public String getName() {
        return "RainSplash";
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull Vec3d location, @Nullable EventType event, @Nullable IOptions inputOptions) {
        ConfigOptions ops = new ConfigOptions();
        ops.setVolumeScale(Weather.getIntensityLevel() * 0.8f);
        ops.setPitchScale(1.75f);
        for (IAcoustic acoustic : this.acoustics) {
            acoustic.playSound(player2, location, event, ops);
        }
    }

    public String toString() {
        return "<< RainSplash >>";
    }
}

