/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.renderer.weather;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.renderer.weather.StormRenderer;
import org.orecruncher.dsurround.client.renderer.weather.StormSplashRenderer;
import org.orecruncher.lib.ReflectedField;

@SideOnly(value=Side.CLIENT)
public final class RenderWeather
extends IRenderHandler {
    private static final ReflectedField.IntegerField<EntityRenderer> rendererUpdateCount = new ReflectedField.IntegerField(EntityRenderer.class, "rendererUpdateCount", "field_78529_t");
    private final StormRenderer stormRenderer = new StormRenderer();

    public static int getRendererUpdateCount() {
        return rendererUpdateCount.get((Object)Minecraft.func_71410_x().field_71460_t);
    }

    protected RenderWeather() {
    }

    public static boolean addRainParticles(@Nonnull EntityRenderer theThis) {
        World world = EnvironStateHandler.EnvironState.getWorld();
        if (world != null && world.field_73011_w.getWeatherRenderer() instanceof RenderWeather) {
            StormSplashRenderer.renderStormSplashes(EnvironStateHandler.EnvironState.getDimensionId(), theThis);
            return true;
        }
        return false;
    }

    public void render(float partialTicks, @Nonnull WorldClient world, @Nonnull Minecraft mc) {
        this.stormRenderer.render(mc.field_71460_t, partialTicks);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(@Nonnull WorldEvent.Load e) {
        if (!ModOptions.asm.enableWeatherASM || !e.getWorld().field_72995_K) {
            return;
        }
        WorldProvider provider = e.getWorld().field_73011_w;
        String dimName = provider.func_186058_p().func_186065_b();
        IRenderHandler renderer = provider.getWeatherRenderer();
        if (renderer == null) {
            ModBase.log().info("Setting weather renderer for dimension [%s]", new Object[]{dimName});
            provider.setWeatherRenderer((IRenderHandler)new RenderWeather());
        } else {
            ModBase.log().info("Not hooking weather renderer for dimension [%s] (%s)", new Object[]{dimName, renderer.getClass()});
        }
    }
}

