/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.renderer;

import com.animania.addons.farm.common.entity.pigs.EntityAnimaniaPig;
import com.animania.addons.farm.common.entity.pigs.EntityPigletBase;
import com.animania.addons.farm.common.entity.sheep.EntityEweBase;
import com.animania.api.interfaces.IFoodEating;
import com.animania.api.interfaces.ISleeping;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.keyboard.KeyHandler;
import org.orecruncher.dsurround.client.renderer.BadgeRenderLayer;

@SideOnly(value=Side.CLIENT)
public final class AnimaniaBadge
implements BadgeRenderLayer.IEntityBadgeProvider {
    private static final ItemStack WATER_BUCKET = new ItemStack(Items.field_151131_as);
    private static final BadgeRenderLayer.IBadgeDisplayCheck BADGE_DISPLAY_CHECK = () -> KeyHandler.ANIMANIA_BADGES == null || KeyHandler.ANIMANIA_BADGES.func_151470_d() || KeyHandler.ANIMANIA_BADGES.func_151463_i() == 0;

    @Override
    @Nonnull
    public ItemStack getStackToDisplay(@Nonnull EntityLivingBase e) {
        IFoodEating fe = (IFoodEating)e;
        if (!fe.getWatered()) {
            return WATER_BUCKET;
        }
        if (!fe.getFed()) {
            return this.getFoodItem(fe);
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getFoodItem(IFoodEating fe) {
        Set food = fe.getFoodItems();
        if (food.size() > 0) {
            ItemStack item = (ItemStack)food.iterator().next();
            return item.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public float adjustY(@Nonnull EntityLivingBase e) {
        if (e instanceof EntityEweBase) {
            return 1.0f;
        }
        if (e instanceof EntityPigletBase) {
            return -0.5f;
        }
        return 0.15f;
    }

    @Override
    public float scale(@Nonnull EntityLivingBase e) {
        if (e instanceof EntityEweBase) {
            return 1.5f;
        }
        if (e instanceof EntityAnimaniaPig && !(e instanceof EntityPigletBase)) {
            return 0.75f;
        }
        return 0.5f;
    }

    @Override
    public boolean show(@Nonnull EntityLivingBase e) {
        if (e instanceof ISleeping) {
            return !((ISleeping)e).getSleeping();
        }
        return true;
    }

    public static void initialize() {
        if (!ModOptions.speechbubbles.enableAnimaniaBadges) {
            return;
        }
        BadgeRenderLayer layer = new BadgeRenderLayer(BADGE_DISPLAY_CHECK, new AnimaniaBadge());
        RenderManager rm = Minecraft.func_71410_x().func_175598_ae();
        for (ResourceLocation r : EntityList.func_180124_b()) {
            Render renderer;
            Class clazz = EntityList.getClass((ResourceLocation)r);
            if (clazz == null || !IFoodEating.class.isAssignableFrom(clazz) || !((renderer = rm.func_78715_a(clazz)) instanceof RenderLivingBase)) continue;
            ((RenderLivingBase)renderer).func_177094_a((LayerRenderer)layer);
            ModBase.log().debug("Adding Animania badging to %s", new Object[]{renderer.getClass().getSimpleName()});
        }
    }
}

