/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import hunternif.mc.atlas.AntiqueAtlasMod;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AbstractMessage<T extends AbstractMessage<T>>
implements IMessage,
IMessageHandler<T, IMessage> {
    protected abstract void read(PacketBuffer var1) throws IOException;

    protected abstract void write(PacketBuffer var1) throws IOException;

    protected abstract void process(EntityPlayer var1, Side var2);

    boolean isValidOnSide(Side side) {
        return true;
    }

    boolean requiresMainThread() {
        return true;
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.read(new PacketBuffer(buffer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toBytes(ByteBuf buffer) {
        try {
            this.write(new PacketBuffer(buffer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final IMessage onMessage(T msg, MessageContext ctx) {
        if (!((AbstractMessage)msg).isValidOnSide(ctx.side)) {
            throw new RuntimeException("Invalid side " + ctx.side.name() + " for " + msg.getClass().getSimpleName());
        }
        if (((AbstractMessage)msg).requiresMainThread()) {
            AbstractMessage.checkThreadAndEnqueue(msg, ctx);
        } else {
            ((AbstractMessage)msg).process(AntiqueAtlasMod.proxy.getPlayerEntity(ctx), ctx.side);
        }
        return null;
    }

    private static <T extends AbstractMessage<T>> void checkThreadAndEnqueue(AbstractMessage<T> msg, MessageContext ctx) {
        IThreadListener thread = AntiqueAtlasMod.proxy.getThreadFromContext(ctx);
        if (!thread.func_152345_ab()) {
            thread.func_152344_a(() -> msg.process(AntiqueAtlasMod.proxy.getPlayerEntity(ctx), ctx.side));
        }
    }

    public static abstract class AbstractServerMessage<T extends AbstractServerMessage<T>>
    extends AbstractMessage<T> {
        @Override
        protected final boolean isValidOnSide(Side side) {
            return side.isServer();
        }
    }

    public static abstract class AbstractClientMessage<T extends AbstractClientMessage<T>>
    extends AbstractMessage<T> {
        @Override
        protected final boolean isValidOnSide(Side side) {
            return side.isClient();
        }
    }
}

