/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.premade.DecimalMinMax;
import com.creativemd.creativecore.common.config.premade.IntMinMax;
import com.creativemd.creativecore.common.config.premade.curve.Curve;
import com.creativemd.creativecore.common.config.premade.curve.DecimalCurve;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.FireParticlesEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.api.type.VisualTypeParticle;
import team.creative.enhancedvisuals.api.type.VisualTypeParticleColored;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.packet.DamagePacket;

public class DamageHandler
extends VisualHandler {
    public static final ArrayList<Item> sharpList = new ArrayList();
    public static final ArrayList<Item> bluntList = new ArrayList();
    public static final ArrayList<Item> pierceList = new ArrayList();
    @CreativeConfig
    public VisualType damaged = new VisualTypeOverlay("damaged");
    @CreativeConfig
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public float hitEffectIntensity = 0.0f;
    @CreativeConfig
    public IntMinMax hitDuration = new IntMinMax(1, 10);
    @CreativeConfig
    public VisualType splatter = new VisualTypeParticle("splatter");
    @CreativeConfig
    public VisualType impact = new VisualTypeParticle("impact");
    @CreativeConfig
    public VisualType slash = new VisualTypeParticle("slash");
    @CreativeConfig
    public VisualType pierce = new VisualTypeParticle("pierce");
    @CreativeConfig
    public IntMinMax bloodDuration = new IntMinMax(500, 1500);
    @CreativeConfig
    public VisualType fire = new VisualTypeParticle("fire");
    @CreativeConfig
    public int fireSplashes = 1;
    @CreativeConfig
    public IntMinMax fireDuration = new IntMinMax(100, 1000);
    @CreativeConfig
    public int drownSplashes = 4;
    @CreativeConfig
    public IntMinMax drownDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType waterDrown = new VisualTypeParticleColored("blob", new Color(0, 0, 255)).setIgnoreWater();
    @CreativeConfig
    public int lightningSplashes = 10;
    @CreativeConfig
    public IntMinMax lightningDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType lightning = new VisualTypeParticleColored("shock", new Color(120, 120, 255)).setIgnoreWater();
    @CreativeConfig
    public int freezeSplashes = 4;
    @CreativeConfig
    public IntMinMax freezeDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType freeze = new VisualTypeParticleColored("ice", new Color(200, 255, 255));
    @CreativeConfig
    public int flyIntoWallSplashes = 4;
    @CreativeConfig
    public IntMinMax flyIntoWallDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType flyIntoWall = new VisualTypeParticleColored("break", new Color(255, 255, 255));
    @CreativeConfig
    public int heatSplashes = 4;
    @CreativeConfig
    public IntMinMax heatDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType heat = new VisualTypeParticleColored("heat", new Color(255, 255, 255)){

        @Override
        public boolean canRotate() {
            return false;
        }
    };
    @CreativeConfig
    public int effectSplashes = 4;
    @CreativeConfig
    public IntMinMax effectDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType parasites = new VisualTypeParticleColored("parasite", new Color(0, 126, 0)).setIgnoreWater();
    @CreativeConfig
    public VisualType wither = new VisualTypeParticleColored("wither", 0, new DecimalMinMax(1.5, 2.5), new Color(0, 0, 0)).setIgnoreWater();
    @CreativeConfig
    public IntMinMax tunnelDuration = new IntMinMax(10, 15);
    @CreativeConfig
    public VisualType tunnel = new VisualTypeOverlay("tunnel", 0).setIgnoreWater();
    @CreativeConfig
    public DecimalCurve healthScaler = new DecimalCurve(0.0, 3.0, 12.0, 1.5);
    @CreativeConfig
    public float damageScale = 1.0f;
    @CreativeConfig
    public List<String> damageBlackList = new ArrayList<String>();
    public static Color bloodColor;

    public void clientHurt() {
        if (this.hitEffectIntensity > 0.0f) {
            VisualManager.addVisualFadeOut(this.damaged, (VisualHandler)this, (Curve)new DecimalCurve(VisualManager.rand, this.hitDuration, (double)this.hitEffectIntensity * 0.2));
        }
    }

    public void playerDamaged(EntityPlayer player, DamagePacket packet) {
        if (packet.source.equalsIgnoreCase("attacker")) {
            if (packet.attackerClass.contains("arrow")) {
                this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
            }
            if (packet.stack != null) {
                if (DamageHandler.isSharp(packet.stack)) {
                    this.createVisualFromDamageAndDistance(this.slash, packet.damage, player, this.bloodDuration);
                } else if (DamageHandler.isBlunt(packet.stack)) {
                    this.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
                } else if (DamageHandler.isPierce(packet.stack)) {
                    this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
                } else {
                    this.createVisualFromDamageAndDistance(this.splatter, packet.damage, player, this.bloodDuration);
                }
            } else if (packet.attackerClass.contains("zombie") || packet.attackerClass.contains("skeleton") || packet.attackerClass.contains("ocelot")) {
                this.createVisualFromDamageAndDistance(this.slash, packet.damage, player, this.bloodDuration);
            } else if (packet.attackerClass.contains("golem") || packet.attackerClass.contains("player")) {
                this.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
            } else if (packet.attackerClass.contains("wolf") || packet.attackerClass.contains("spider")) {
                this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
            } else {
                this.createVisualFromDamageAndDistance(this.splatter, Math.min(20.0f, packet.damage), player, this.bloodDuration);
            }
        } else if (packet.source.equalsIgnoreCase("cactus")) {
            this.createVisualFromDamageAndDistance(this.pierce, packet.damage, player, this.bloodDuration);
        } else if (packet.source.equalsIgnoreCase("fall") || packet.source.equalsIgnoreCase("fallingBlock")) {
            this.createVisualFromDamageAndDistance(this.impact, packet.damage, player, this.bloodDuration);
        } else if (packet.source.equalsIgnoreCase("drown")) {
            VisualManager.addParticlesFadeOut(this.waterDrown, (VisualHandler)this, this.drownSplashes, this.drownDuration, true);
        } else if (packet.source.equalsIgnoreCase("hypothermia")) {
            VisualManager.addParticlesFadeOut(this.freeze, (VisualHandler)this, this.freezeSplashes, this.freezeDuration, true);
        } else if (packet.source.equalsIgnoreCase("hyperthermia")) {
            VisualManager.addParticlesFadeOut(this.heat, (VisualHandler)this, this.heatSplashes, this.heatDuration, true);
        } else if (packet.source.equalsIgnoreCase("wither")) {
            VisualManager.addParticlesFadeOut(this.wither, (VisualHandler)this, this.effectSplashes, this.effectDuration, true);
        } else if (packet.source.equalsIgnoreCase("parasites")) {
            VisualManager.addParticlesFadeOut(this.parasites, (VisualHandler)this, this.effectSplashes, this.effectDuration, true);
        } else if (packet.source.equalsIgnoreCase("lightningBolt")) {
            VisualManager.addParticlesFadeOut(this.lightning, (VisualHandler)this, this.lightningSplashes, this.lightningDuration, true);
        } else if (packet.source.equalsIgnoreCase("flyIntoWall")) {
            VisualManager.addParticlesFadeOut(this.flyIntoWall, (VisualHandler)this, this.flyIntoWallSplashes, this.flyIntoWallDuration, true);
        } else if (packet.source.equalsIgnoreCase("dehydration") || packet.source.equalsIgnoreCase("starve")) {
            VisualManager.addVisualFadeOut(this.tunnel, (VisualHandler)this, this.tunnelDuration);
        } else if (packet.fire || packet.source.equalsIgnoreCase("onFire")) {
            FireParticlesEvent event = new FireParticlesEvent(this.fireSplashes, this.fireDuration.min, this.fireDuration.max);
            MinecraftForge.EVENT_BUS.post((Event)event);
            VisualManager.addParticlesFadeOut(this.fire, (VisualHandler)this, event.getNewFireSplashes(), new IntMinMax(event.getNewFireDurationMin(), event.getNewFireDurationMax()), true, new Color(0, 0, 0));
        } else if (!this.damageBlackList.contains(packet.source)) {
            this.createVisualFromDamageAndDistance(this.splatter, Math.min(20.0f, packet.damage), player, this.bloodDuration);
        }
    }

    public void createVisualFromDamageAndDistance(VisualType type, float damage, EntityPlayer player, IntMinMax duration) {
        if (damage <= 0.0f) {
            return;
        }
        float health = player.func_110143_aJ() - damage;
        double rate = Math.max(0.0, this.healthScaler.valueAt((double)health));
        VisualManager.addParticlesFadeOut(type, (VisualHandler)this, (int)((double)(this.damageScale * damage) * rate), (Curve)new DecimalCurve(0.0, 1.0, (double)duration.next(VisualManager.rand), 0.0), true, bloodColor);
    }

    private static boolean isSharp(ItemStack item) {
        return sharpList.contains(item.func_77973_b());
    }

    private static boolean isBlunt(ItemStack item) {
        return bluntList.contains(item.func_77973_b());
    }

    private static boolean isPierce(ItemStack item) {
        return pierceList.contains(item.func_77973_b());
    }

    static {
        sharpList.add(Items.field_151040_l);
        sharpList.add(Items.field_151041_m);
        sharpList.add(Items.field_151052_q);
        sharpList.add(Items.field_151048_u);
        sharpList.add(Items.field_151010_B);
        sharpList.add(Items.field_151036_c);
        sharpList.add(Items.field_151053_p);
        sharpList.add(Items.field_151049_t);
        sharpList.add(Items.field_151056_x);
        sharpList.add(Items.field_151006_E);
        bluntList.add(Items.field_151035_b);
        bluntList.add(Items.field_151039_o);
        bluntList.add(Items.field_151050_s);
        bluntList.add(Items.field_151046_w);
        bluntList.add(Items.field_151005_D);
        bluntList.add(Items.field_151037_a);
        bluntList.add(Items.field_151038_n);
        bluntList.add(Items.field_151051_r);
        bluntList.add(Items.field_151047_v);
        bluntList.add(Items.field_151011_C);
        pierceList.add(Items.field_151019_K);
        pierceList.add(Items.field_151017_I);
        pierceList.add(Items.field_151018_J);
        pierceList.add(Items.field_151012_L);
        pierceList.add(Items.field_151013_M);
        pierceList.add(Items.field_151032_g);
        bloodColor = new Color(0.3f, 0.01f, 0.01f, 0.7f);
    }
}

