/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.enchantments;

import crafttweaker.api.enchantments.IEnchantment;
import crafttweaker.api.enchantments.IEnchantmentDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.enchantments.MCEnchantment;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MCEnchantmentDefinition
implements IEnchantmentDefinition {
    public final Enchantment enchantment;

    public MCEnchantmentDefinition(Enchantment enchantment) {
        this.enchantment = enchantment;
    }

    public MCEnchantmentDefinition(int id) {
        this(Enchantment.func_185262_c((int)id));
    }

    @Override
    public int getID() {
        return Enchantment.func_185258_b((Enchantment)this.enchantment);
    }

    @Override
    public String getRegistryName() {
        ResourceLocation registryName = this.enchantment.getRegistryName();
        return registryName != null ? registryName.toString() : null;
    }

    @Override
    public String getName() {
        return this.enchantment.func_77320_a();
    }

    @Override
    public void setName(String name) {
        this.enchantment.func_77322_b(name);
    }

    @Override
    public boolean canApply(IItemStack itemStack) {
        return this.enchantment.func_92089_a((ItemStack)itemStack.getInternal());
    }

    @Override
    public boolean canApplyAtEnchantmentTable(IItemStack itemStack) {
        return this.enchantment.canApplyAtEnchantingTable((ItemStack)itemStack.getInternal());
    }

    @Override
    public int getMaxLevel() {
        return this.enchantment.func_77325_b();
    }

    @Override
    public int getMinLevel() {
        return this.enchantment.func_77319_d();
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return this.enchantment.func_77317_b(enchantmentLevel);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return this.enchantment.func_77321_a(enchantmentLevel);
    }

    @Override
    public String getTranslatedName(int enchantmentLevel) {
        return this.enchantment.func_77316_c(enchantmentLevel);
    }

    @Override
    public boolean isAllowedOnBooks() {
        return this.enchantment.isAllowedOnBooks();
    }

    @Override
    public boolean isCompatibleWith(IEnchantmentDefinition other) {
        return this.enchantment.func_191560_c((Enchantment)other.getInternal());
    }

    @Override
    public boolean isCurse() {
        return this.enchantment.func_190936_d();
    }

    @Override
    public boolean isTreasureEnchantment() {
        return this.enchantment.func_185261_e();
    }

    @Override
    public IEnchantment makeEnchantment(int level) {
        return new MCEnchantment(this.enchantment, level);
    }

    @Override
    public int compare(IEnchantmentDefinition other) {
        return Integer.compare(this.getID(), other.getID());
    }

    @Override
    public Object getInternal() {
        return this.enchantment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCEnchantmentDefinition that = (MCEnchantmentDefinition)o;
        return Objects.equals(this.enchantment, that.enchantment);
    }

    public int hashCode() {
        return Objects.hash(this.enchantment);
    }
}

