/*
 * Decompiled with CFR 0.152.
 */
package crafttweakerutils.preprocessors;

import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import stanhebben.zenscript.ZenRuntimeException;

public class OnSidePreprocessor
extends PreprocessorActionBase {
    private static final String PREPROCESSOR_NAME = "onside";
    private Side side;

    public OnSidePreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        String s;
        switch (s = preprocessorLine.substring(7).trim().toLowerCase()) {
            case "server": {
                this.side = Side.SERVER;
                break;
            }
            case "client": {
                this.side = Side.CLIENT;
                break;
            }
            default: {
                throw new ZenRuntimeException("Invalid value for preprocessor. Must be one of 'server' or 'client'.");
            }
        }
    }

    public void executeActionOnFind(ScriptFile scriptFile) {
        if (FMLCommonHandler.instance().getSide() != this.side) {
            scriptFile.setParsingBlocked(true);
            scriptFile.setCompileBlocked(true);
            scriptFile.setExecutionBlocked(true);
        }
    }

    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }
}

