/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.OwnerDef;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class Instructions {
    @Nonnull
    public static final NBTTagCompound createshell(@Nonnull ItemStack stack) {
        return ItemStacks.getTagCompoundNonNull(stack, "_Hord_Instructions");
    }

    @Nonnull
    public static final NBTTagCompound createshell(@Nonnull ItemStack stack, @Nonnull String modid) {
        NBTTagCompound nbt_instr = ItemStacks.getTagCompoundNonNull(stack, "_Hord_Instructions");
        if (!modid.isEmpty()) {
            nbt_instr.func_74778_a("ModId", modid);
        }
        return nbt_instr;
    }

    @Nonnull
    public static final NBTTagCompound create(@Nonnull ItemStack stack, int currentVersion) {
        Validate.isTrue((currentVersion > 0 && currentVersion < 128 ? 1 : 0) != 0, (String)"Invalid version", (Object[])new Object[0]);
        NBTTagCompound nbt_instr = ItemStacks.getTagCompoundNonNull(stack, "_Hord_Instructions");
        nbt_instr.func_74774_a("Version", (byte)currentVersion);
        return nbt_instr;
    }

    @Nonnull
    public static final NBTTagCompound create(@Nonnull ItemStack stack, int currentVersion, @Nonnull String modid) {
        assert (modid != null);
        NBTTagCompound nbt_instr = Instructions.create(stack, currentVersion);
        if (!modid.isEmpty()) {
            nbt_instr.func_74778_a("ModId", modid);
        }
        return nbt_instr;
    }

    public static final boolean present(@Nullable ItemStack stack) {
        return !ItemStacks.isEmpty(stack) ? stack.func_179543_a("_Hord_Instructions") != null : false;
    }

    @Nullable
    public static final NBTTagCompound get(@Nullable ItemStack stack) {
        NBTTagCompound nbt_instr = null;
        if (!ItemStacks.isEmpty(stack)) {
            nbt_instr = stack.func_179543_a("_Hord_Instructions");
        }
        return nbt_instr;
    }

    @Nullable
    public static final NBTTagCompound get(@Nullable ItemStack stack, int requiredVersion, boolean olderOk) {
        Validate.isTrue((requiredVersion > 0 && requiredVersion < 128 ? 1 : 0) != 0, (String)"Invalid version (not allowed to be lte 0", (Object[])new Object[0]);
        NBTTagCompound nbt_instr = null;
        NBTTagCompound tst_instr = Instructions.get(stack);
        if (tst_instr != null) {
            if (tst_instr.func_150297_b("Version", 1)) {
                byte v = tst_instr.func_74771_c("Version");
                if (v != 0 && (requiredVersion == v || olderOk && v < requiredVersion)) {
                    nbt_instr = tst_instr;
                }
            } else if (olderOk && 0 <= requiredVersion) {
                nbt_instr = tst_instr;
            }
        }
        return nbt_instr;
    }

    @Nullable
    public static final NBTTagCompound getraw(@Nullable ItemStack stack) {
        NBTTagCompound nbt_instr = null;
        if (stack != null && stack != ItemStack.field_190927_a) {
            nbt_instr = stack.func_179543_a("_Hord_Instructions");
        }
        return nbt_instr;
    }

    public static final void remove(@Nonnull ItemStack stack) {
        stack.func_190919_e("_Hord_Instructions");
    }

    public static final boolean copyinit(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        boolean changed = false;
        NBTTagCompound nbt_instr = Instructions.get(from);
        to.func_190919_e("_Hord_Instructions");
        if (nbt_instr != null) {
            NBTTagCompound cpy_instr = nbt_instr.func_74737_b();
            to.func_77983_a("_Hord_Instructions", (NBTBase)cpy_instr);
            changed = true;
        }
        return changed;
    }

    public static final boolean copyinit(@Nonnull ItemStack from, @Nonnull ItemStack to, int currentVersion) {
        boolean changed = Instructions.copyinit(from, to);
        if (changed) {
            Validate.isTrue((currentVersion > 0 && currentVersion < 128 ? 1 : 0) != 0, (String)"Invalid version", (Object[])new Object[0]);
            Instructions.get(to).func_74774_a("Version", (byte)currentVersion);
        } else {
            Instructions.create(to, currentVersion);
            changed = true;
        }
        return changed;
    }

    public static final boolean setVersion(@Nonnull ItemStack to, int currentVersion) {
        Validate.isTrue((currentVersion > 0 && currentVersion < 128 ? 1 : 0) != 0, (String)"Invalid version", (Object[])new Object[0]);
        NBTTagCompound nbt_instr = Instructions.getraw(to);
        if (nbt_instr != null) {
            nbt_instr.func_74774_a("Version", (byte)currentVersion);
        }
        return nbt_instr != null;
    }

    public static final boolean isCustomFor(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        NBTTagCompound instr = Instructions.get(stack);
        return instr != null && modid.equals(instr.func_74779_i("ModId"));
    }

    public static final boolean isXEnchanted(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return nbt_instr != null && modid.equals(nbt_instr.func_74779_i("ModId")) && nbt_instr.func_74762_e("PrizeEnchant") > 0;
    }

    public static final boolean isLooted(@Nullable ItemStack stack, @Nullable String modid) {
        boolean is = false;
        NBTTagCompound nbt_instr = Instructions.get(stack);
        if (nbt_instr != null && (modid == null || modid.equals(nbt_instr.func_74779_i("ModId")))) {
            is = nbt_instr.func_74767_n("Looted");
        }
        return is;
    }

    public static final boolean isLooted(@Nullable ItemStack stack) {
        return Instructions.isLooted(stack, null);
    }

    public static final boolean isUnvanishing(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return Instructions.isXEnchanted(stack, modid) && nbt_instr.func_74767_n("Unvanishing");
    }

    public static final boolean hasXGearFlag(@Nullable ItemStack stack, @Nonnull String modid) {
        assert (modid != null);
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return Instructions.isXEnchanted(stack, modid) && nbt_instr.func_74767_n("XGear");
    }

    public static final boolean hasXFoodFlag(@Nullable ItemStack stack) {
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_74764_b("XFood") && nbt_instr.func_74767_n("XFood");
    }

    public static final boolean hasLootTable(@Nullable ItemStack stack, boolean topLevel) {
        NBTTagCompound nbt = Instructions.get(stack);
        if (nbt != null && nbt.func_150297_b(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME(), 8)) {
            return true;
        }
        nbt = stack.func_77978_p();
        return topLevel && nbt != null && (nbt.func_74764_b(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME()) || nbt.func_74764_b("withLoot"));
    }

    public static final boolean hasUnrepairableFlag(@Nullable ItemStack stack) {
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_74764_b("Unrepairable") && nbt_instr.func_74767_n("Unrepairable");
    }

    public static final int getInteger(@Nullable ItemStack stack, @Nonnull String tagid, int valueIfAbsent) {
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 99) ? nbt_instr.func_74762_e(tagid) : valueIfAbsent;
    }

    static final NBTTagCompound setInteger_(@Nonnull ItemStack stack, @Nonnull String tagid, int value) {
        NBTTagCompound nbt_instr = Instructions.createshell(stack);
        nbt_instr.func_74768_a(tagid, value);
        return nbt_instr;
    }

    public static final int setInteger(@Nullable ItemStack stack, @Nonnull String tagid, int value, int nullValue) {
        int oldValue = Instructions.getInteger(stack, tagid, nullValue);
        Instructions.setInteger_(stack, tagid, value);
        return oldValue;
    }

    public static final int getIntegerRaw(@Nullable ItemStack stack, @Nonnull String tagid, int valueIfAbsent) {
        NBTTagCompound nbt_instr = Instructions.getraw(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 99) ? nbt_instr.func_74762_e(tagid) : valueIfAbsent;
    }

    public static final boolean getFlag(@Nullable ItemStack stack, @Nonnull String tagid) {
        NBTTagCompound nbt_instr = Instructions.get(stack);
        return nbt_instr != null && nbt_instr.func_150297_b(tagid, 1) ? nbt_instr.func_74767_n(tagid) : false;
    }

    public static final boolean setFlag(@Nullable ItemStack stack, @Nonnull String tagid, Boolean value) {
        boolean oldValue = Instructions.getFlag(stack, tagid);
        NBTTagCompound nbt_instr = Instructions.createshell(stack);
        if (value == null) {
            nbt_instr.func_82580_o(tagid);
        } else {
            nbt_instr.func_74757_a(tagid, Boolean.TRUE.equals(value));
        }
        return oldValue;
    }

    public static final int getUsed(@Nullable ItemStack stack, int valueIfAbsent) {
        return Instructions.getInteger(stack, "Used", valueIfAbsent);
    }

    public static final int getCheckedUsed(@Nullable ItemStack stack, int valueIfAbsent, int maxValue) {
        int n = Instructions.getUsed(stack, valueIfAbsent);
        if (n < 0) {
            n = valueIfAbsent;
        }
        return Math.min(n, maxValue);
    }

    public static final void setUsed(@Nonnull ItemStack stack, int value, int capacityIfAbsent) {
        NBTTagCompound nbt_instr = Instructions.setInteger_(stack, "Used", value);
        if (capacityIfAbsent > 0) {
            if (!nbt_instr.func_150297_b("Capacity", 99)) {
                Instructions.setCapacity(stack, capacityIfAbsent);
            }
            if (value > capacityIfAbsent) {
                Instructions.setInteger_(stack, "Used", capacityIfAbsent);
            }
        }
    }

    public static final int getCapacity(@Nullable ItemStack stack, int valueIfAbsent) {
        return Instructions.getInteger(stack, "Capacity", valueIfAbsent);
    }

    public static final int getCheckedCapacity(@Nullable ItemStack stack, int valueIfAbsent, int maxValue) {
        int n = Instructions.getCapacity(stack, valueIfAbsent);
        if (n < 0) {
            n = valueIfAbsent;
        }
        return Math.min(n, maxValue);
    }

    public static final void setCapacity(@Nonnull ItemStack stack, int capacity) {
        Instructions.setInteger_(stack, "Capacity", capacity);
    }

    public static final int getRemaining(@Nullable ItemStack stack, int capacityIfAbsent, int maxCapacity) {
        int n;
        int m;
        NBTTagCompound nbt_instr = Instructions.get(stack);
        if (nbt_instr == null) {
            return capacityIfAbsent;
        }
        int n2 = m = nbt_instr.func_150297_b("Capacity", 99) ? nbt_instr.func_74762_e("Capacity") : capacityIfAbsent;
        if (m < 0) {
            m = capacityIfAbsent;
        }
        int n3 = n = nbt_instr.func_150297_b("Used", 99) ? nbt_instr.func_74762_e("Used") : 0;
        if (n < 0) {
            n = 0;
        }
        return MathHelper.func_76125_a((int)(m - n), (int)0, (int)maxCapacity);
    }

    public static final int getColorRgb(@Nonnull ItemStack stack, int valueIfAbsent) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_COLOR_TAGNAME(), 3)) {
            return stack.func_77978_p().func_74762_e(SharedGlue.CUSTOM_COLOR_TAGNAME());
        }
        NBTTagCompound nbt_instr = Instructions.get(stack);
        if (nbt_instr != null && nbt_instr.func_150297_b("ColorRGB", 3)) {
            return nbt_instr.func_74762_e("ColorRGB");
        }
        return valueIfAbsent;
    }

    public static final int renameLikeAnvil(@Nonnull ItemStack target, String newname) {
        int cost = 0;
        if (StringUtils.isBlank((CharSequence)newname)) {
            if (target.func_82837_s()) {
                target.func_135074_t();
                ++cost;
            }
        } else if (!newname.equals(target.func_82833_r())) {
            target.func_151001_c(newname);
            ++cost;
        }
        return cost;
    }

    public static final int namedOnAvil(@Nonnull ItemStack creation, @Nonnull ItemStack original, String newname) {
        int cost = 0;
        if (!StringUtils.isBlank((CharSequence)newname) && !newname.equals(original.func_82833_r())) {
            creation.func_151001_c(newname);
            ++cost;
        }
        return cost;
    }

    public static final boolean setOwner(ItemStack stack, EntityPlayer player, boolean forced) {
        if (ItemStacks.isEmpty(stack) || !SharedGlue.isRealPlayer((Entity)player)) {
            return false;
        }
        boolean setted = false;
        String uuid = player.func_189512_bd();
        if (!StringUtils.isBlank((CharSequence)uuid)) {
            String uuid_present;
            NBTTagCompound instr = Instructions.createshell(stack);
            if (!forced && instr.func_150297_b("OwnerUUID", 8) && !(uuid_present = instr.func_74779_i("OwnerUUID")).isEmpty() && !uuid.equals(uuid_present)) {
                return false;
            }
            instr.func_74778_a("OwnerUUID", uuid);
            instr.func_74778_a("OwnerName", player.func_70005_c_());
            setted = true;
        }
        return setted;
    }

    public static final boolean setOwner(ItemStack stack, String uuid) {
        if (ItemStacks.isEmpty(stack)) {
            return false;
        }
        NBTTagCompound instr = Instructions.createshell(stack);
        instr.func_74778_a("OwnerUUID", uuid);
        instr.func_82580_o("OwnerName");
        return true;
    }

    public static final boolean setOwner(ItemStack stack, @Nonnull OwnerDef owner) {
        if (ItemStacks.isEmpty(stack) || StringUtils.isBlank((CharSequence)owner.uuid)) {
            return false;
        }
        NBTTagCompound instr = Instructions.createshell(stack);
        instr.func_74778_a("OwnerUUID", owner.uuid);
        if (StringUtils.isBlank((CharSequence)owner.name)) {
            instr.func_82580_o("OwnerName");
        } else {
            instr.func_74778_a("OwnerName", owner.name);
        }
        return true;
    }

    @Nullable
    public static String getOwner(ItemStack stack) {
        OwnerDef owner = Instructions.getOwnerDef(stack);
        return owner != null ? owner.uuid : null;
    }

    @Nullable
    public static OwnerDef getOwnerDef(ItemStack stack) {
        String uuid;
        NBTTagCompound instr;
        OwnerDef owner = null;
        if (!ItemStacks.isEmpty(stack) && (instr = Instructions.get(stack)) != null && (uuid = StringUtils.trimToNull((String)instr.func_74779_i("OwnerUUID"))) != null) {
            owner = new OwnerDef();
            owner.uuid = uuid;
            if (instr.func_150297_b("OwnerName", 8)) {
                owner.name = instr.func_74779_i("OwnerName");
            }
        }
        return owner;
    }

    public static final boolean isOwner(ItemStack stack, EntityPlayer player, boolean emptyIsMatch) {
        String uuid;
        boolean is;
        NBTTagCompound instr = Instructions.get(stack);
        boolean bl = is = instr != null;
        is = is ? ((uuid = instr.func_74779_i("OwnerUUID")).isEmpty() ? emptyIsMatch : uuid.equals(player.func_189512_bd())) : emptyIsMatch;
        return is;
    }

    public static final boolean isOwnerOrUnowned(ItemStack stack, EntityPlayer player) {
        return Instructions.isOwner(stack, player, true);
    }

    public static final void clearOwner(ItemStack stack) {
        NBTTagCompound instr;
        if (!ItemStacks.isEmpty(stack) && (instr = Instructions.get(stack)) != null) {
            instr.func_82580_o("OwnerUUID");
            instr.func_82580_o("OwnerName");
        }
    }

    public static final boolean hasOwner(ItemStack stack) {
        NBTTagCompound instr = Instructions.get(stack);
        return instr != null ? !instr.func_74779_i("OwnerUUID").isEmpty() : false;
    }
}

