/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.recipes;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.init.Elements;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.traits.elements.Element;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.recipes.RecipeHelperUtil;

public class RecipeDragonEye
extends ShapedOreRecipe {
    public RecipeDragonEye(@Nullable ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return super.func_77569_a(inv, world);
    }

    public ItemStack func_77571_b() {
        ItemStack output = super.func_77571_b().func_77946_l();
        boolean checkSkull = false;
        if (Trinkets.IceAndFire && output.func_77973_b() instanceof AccessoryBase) {
            block0: for (Ingredient i : this.func_192400_c()) {
                if (checkSkull) break;
                for (ItemStack stack : i.func_193365_a()) {
                    if (checkSkull) continue block0;
                    if (!this.matchItem(stack, "iceandfire:dragon_skull")) continue;
                    int meta = stack.func_77960_j();
                    if (meta == 1) {
                        this.setTrinketProperties(output, 2, Elements.ICE);
                    } else if (meta == 2) {
                        this.setTrinketProperties(output, 3, Elements.LIGHTNING);
                    } else {
                        this.setTrinketProperties(output, 1, Elements.FIRE);
                    }
                    checkSkull = true;
                }
            }
        }
        return output;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack output = super.func_77572_b(inv);
        try {
            if (output.func_77942_o()) {
                Capabilities.getTrinketProperties(output, prop -> prop.loadFromNBT(output.func_77978_p()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Trinkets.IceAndFire && output.func_77973_b() instanceof AccessoryBase) {
            try {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!this.matchDragonSkullStage(stack)) continue;
                    if (stack.func_77952_i() == 1) {
                        if (!TrinketsConfig.SERVER.Items.DRAGON_EYE.compat.iaf.ICE_VARIANT) continue;
                        this.setTrinketProperties(output, 2, Elements.ICE);
                        continue;
                    }
                    if (stack.func_77952_i() == 2) {
                        if (!TrinketsConfig.SERVER.Items.DRAGON_EYE.compat.iaf.LIGHTNING_VARIANT) continue;
                        this.setTrinketProperties(output, 3, Elements.LIGHTNING);
                        continue;
                    }
                    this.setTrinketProperties(output, 1, Elements.FIRE);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    private boolean testItem(ItemStack stack, Predicate<ItemStack> predicate) {
        return stack == null || stack.func_190926_b() || predicate == null ? false : predicate.test(stack);
    }

    private boolean matchItem(ItemStack stack, String regName) {
        return regName == null || regName.isEmpty() ? false : this.testItem(stack, s -> {
            Item item = s.func_77973_b();
            return item.getRegistryName().toString().equalsIgnoreCase(regName);
        });
    }

    private boolean matchDragonSkullStage(ItemStack stack) {
        return this.matchItem(stack, "iceandfire:dragon_skull") && stack.func_77942_o() && !stack.func_77978_p().func_82582_d() && stack.func_77978_p().func_74762_e("Stage") >= TrinketsConfig.SERVER.Items.DRAGON_EYE.compat.iaf.stage;
    }

    private void setTrinketProperties(ItemStack stack, int variant, Element element) {
        Capabilities.getTrinketProperties(stack, prop -> {
            if (variant >= 0) {
                prop.setVariant(variant);
            }
            prop.getElementAttributes().setPrimaryElement(element);
        });
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            CraftingHelper.ShapedPrimer primer = RecipeHelperUtil.parseShaped(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new RecipeDragonEye(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
        }
    }
}

