/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.helpers;

import com.google.common.collect.ImmutableList;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.util.helpers.RayTraceHelper;

public class BlockHelperUtil {
    public static TreeMap<Double, Vec3d> findAll(Vec3d origin, World world, AxisAlignedBB aabb, BiPredicate<IBlockState, BlockPos> predicate) {
        TreeMap<Double, Vec3d> collection = new TreeMap<Double, Vec3d>();
        if (predicate != null) {
            int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
            int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
            int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
            int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
            int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
            int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        Vec3d pos = new Vec3d((double)k1, (double)l1, (double)i2);
                        BlockPos bPos = new BlockPos(pos);
                        IBlockState state = world.func_180495_p(bPos);
                        if (!predicate.test(state, bPos)) continue;
                        double blockDist = pos.func_72438_d(origin);
                        collection.put(blockDist, pos);
                    }
                }
            }
        }
        return collection;
    }

    public static BlockPos findFirst(Vec3d origin, World world, AxisAlignedBB aabb, BiPredicate<IBlockState, BlockPos> predicate) {
        if (predicate != null) {
            int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
            int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
            int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
            int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
            int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
            int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        Vec3d pos = new Vec3d((double)k1, (double)l1, (double)i2);
                        BlockPos bPos = new BlockPos(pos);
                        IBlockState state = world.func_180495_p(bPos);
                        if (!predicate.test(state, bPos)) continue;
                        return bPos;
                    }
                }
            }
        }
        return new BlockPos(origin);
    }

    public static boolean isBlockNearby(World world, AxisAlignedBB aabb, BiPredicate<IBlockState, BlockPos> predicate) {
        if (predicate != null) {
            int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
            int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
            int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
            int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
            int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
            int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        Vec3d pos = new Vec3d((double)k1, (double)l1, (double)i2);
                        BlockPos bPos = new BlockPos(pos);
                        IBlockState state = world.func_180495_p(bPos);
                        if (!predicate.test(state, bPos)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean canToolHarvestBlock(ItemStack stack, IBlockState state) {
        return BlockHelperUtil.canToolHarvestBlock(stack, state, 0);
    }

    public static boolean canToolHarvestBlock(ItemStack stack, IBlockState state, int bonusToolLevel) {
        Block block = state.func_177230_c();
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        String type = block.getHarvestTool(state);
        int level = block.getHarvestLevel(state);
        return stack.func_77973_b().getHarvestLevel(stack, type, null, state) + bonusToolLevel >= level;
    }

    public static boolean canPlayerHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, ItemStack harvestTool, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return BlockHelperUtil.canPlayerHarvestBlock(block, player, harvestTool, world, pos, 0);
    }

    public static boolean canPlayerHarvestBlock(@Nonnull Block block, @Nonnull EntityPlayer player, ItemStack harvestTool, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, int bonusToolLevel) {
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_177230_c().func_176221_a(state, world, pos)).func_185904_a().func_76229_l()) {
            return true;
        }
        String tool = block.getHarvestTool(state);
        if (tool == null || harvestTool.func_190926_b()) {
            return player.func_184823_b(state);
        }
        int toolLevel = harvestTool.func_77973_b().getHarvestLevel(harvestTool, tool, player, state) + bonusToolLevel;
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean isToolEffective(ItemStack stack, IBlockState state) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (type == null || !type.equals(state.func_177230_c().getHarvestTool(state))) continue;
            return true;
        }
        return state.func_177230_c().getHarvestTool(state) == null;
    }

    public static float getEntityDigSpeed(EntityLivingBase entity, ItemStack itemstack, IBlockState state, BlockPos pos) {
        return BlockHelperUtil.getEntityDigSpeed(entity, itemstack, state, pos, true);
    }

    public static float getEntityDigSpeed(EntityLivingBase entity, ItemStack itemstack, IBlockState state, BlockPos pos, boolean callDigSpeedEvent) {
        int i;
        float f = 1.0f;
        if (!itemstack.func_190926_b()) {
            f *= itemstack.func_150997_a(state);
        }
        if (f > 1.0f && (i = EnchantmentHelper.func_185293_e((EntityLivingBase)entity)) > 0 && !itemstack.func_190926_b()) {
            f += (float)(i * i + 1);
        }
        if (entity.func_70644_a(MobEffects.field_76422_e)) {
            f *= 1.0f + (float)(entity.func_70660_b(MobEffects.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (entity.func_70644_a(MobEffects.field_76419_f)) {
            float f1;
            switch (entity.func_70660_b(MobEffects.field_76419_f).func_76458_c()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (entity.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)entity)) {
            f /= 5.0f;
        }
        if (!entity.field_70122_E) {
            f /= 5.0f;
        }
        if (callDigSpeedEvent && entity instanceof EntityPlayer) {
            f = ForgeEventFactory.getBreakSpeed((EntityPlayer)((EntityPlayer)entity), (IBlockState)state, (float)f, (BlockPos)pos);
        }
        return f < 0.0f ? 0.0f : f;
    }

    public static ImmutableList<BlockPos> getBlockList(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth) {
        return BlockHelperUtil.getBlockList(stack, world, player, origin, width, height, depth, -1, null);
    }

    public static ImmutableList<BlockPos> getBlockList(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, Predicate<BlockPos> predicate) {
        return BlockHelperUtil.getBlockList(stack, world, player, origin, width, height, depth, -1, predicate);
    }

    public static ImmutableList<BlockPos> getBlockList(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, int distance) {
        return BlockHelperUtil.getBlockList(stack, world, player, origin, width, height, depth, distance, null);
    }

    public static ImmutableList<BlockPos> getBlockList(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, int distance, Predicate<BlockPos> predicate) {
        int z;
        int y;
        int x;
        IBlockState state = world.func_180495_p(origin);
        if (state.func_185904_a() == Material.field_151579_a || !BlockHelperUtil.canToolHarvestBlock(stack, state)) {
            return ImmutableList.of();
        }
        RayTraceResult targetPoint = RayTraceHelper.rayTrace(world, (EntityLivingBase)player, true);
        if (!(targetPoint != null && origin.equals((Object)targetPoint.func_178782_a()) || (targetPoint = RayTraceHelper.rayTrace(world, (EntityLivingBase)player, false)) != null && origin.equals((Object)targetPoint.func_178782_a()))) {
            return ImmutableList.of();
        }
        BlockPos start = origin;
        switch (targetPoint.field_178784_b) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.func_174811_aO().func_176730_m();
                x = vec.func_177958_n() * height + vec.func_177952_p() * width;
                y = targetPoint.field_178784_b.func_176743_c().func_179524_a() * -depth;
                z = vec.func_177958_n() * width + vec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && targetPoint.field_72307_f.field_72450_a - (double)targetPoint.func_178782_a().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && targetPoint.field_72307_f.field_72450_a - (double)targetPoint.func_178782_a().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && targetPoint.field_72307_f.field_72449_c - (double)targetPoint.func_178782_a().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(targetPoint.field_72307_f.field_72449_c - (double)targetPoint.func_178782_a().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = targetPoint.field_178784_b.func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && targetPoint.field_72307_f.field_72450_a - (double)targetPoint.func_178782_a().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(targetPoint.field_72307_f.field_72448_b - (double)targetPoint.func_178782_a().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = targetPoint.field_178784_b.func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && targetPoint.field_72307_f.field_72448_b - (double)targetPoint.func_178782_a().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(targetPoint.field_72307_f.field_72449_c - (double)targetPoint.func_178782_a().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance) continue;
                    BlockPos pos = new BlockPos(xp, yp, zp);
                    if (predicate != null && !predicate.test(pos) || !BlockHelperUtil.isToolEffective(stack, world.func_180495_p(pos))) continue;
                    builder.add((Object)pos);
                }
            }
        }
        return builder.build();
    }

    public static boolean canBreakBlock(ItemStack stack, World world, EntityPlayer player, BlockPos harvestedPos, BlockPos targetPos) {
        return BlockHelperUtil.canBreakBlock(stack, world, player, harvestedPos, targetPos, 0);
    }

    public static boolean canBreakBlock(ItemStack stack, World world, EntityPlayer player, BlockPos harvestedPos, BlockPos targetPos, int bonusToolLevel) {
        float strength;
        boolean tooSlow;
        if (world.func_175623_d(targetPos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(targetPos);
        Block block = state.func_177230_c();
        if (!BlockHelperUtil.isToolEffective(stack, state)) {
            return false;
        }
        IBlockState refState = world.func_180495_p(harvestedPos);
        float refStrength = ForgeHooks.blockStrength((IBlockState)refState, (EntityPlayer)player, (World)world, (BlockPos)harvestedPos);
        boolean bl = tooSlow = refStrength / (strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)targetPos)) > 10.0f;
        if (!BlockHelperUtil.canPlayerHarvestBlock(block, player, stack, (IBlockAccess)world, targetPos, bonusToolLevel) || tooSlow) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, targetPos, state, player);
            if (block.removedByPlayer(state, world, targetPos, player, false)) {
                block.func_176206_d(world, targetPos, state);
            }
            if (!world.field_72995_K) {
                NetworkHandler.sendPacket((Entity)player, new SPacketBlockChange(world, targetPos));
            }
            return false;
        }
        return true;
    }

    public static void breakBlock(EntityPlayer entity, ItemStack harvestTool, World world, IBlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos) {
        BlockHelperUtil.breakBlock(entity, harvestTool, world, harvestedBlockState, harvestedPos, targetPos, true);
    }

    public static void breakBlock(EntityPlayer entity, ItemStack harvestTool, World world, IBlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos, boolean callBreakEvent) {
        BlockHelperUtil.breakBlock(entity, harvestTool, world, harvestedBlockState, harvestedPos, targetPos, callBreakEvent, 0);
    }

    public static void breakBlock(EntityPlayer entity, ItemStack harvestTool, World world, IBlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos, boolean callBreakEvent, int bonusToolLevel) {
        BlockHelperUtil.breakBlock(entity, harvestTool, world, harvestedBlockState, harvestedPos, targetPos, callBreakEvent, bonusToolLevel, null);
    }

    public static void breakBlock(EntityPlayer entity, ItemStack harvestTool, World world, IBlockState harvestedBlockState, BlockPos harvestedPos, BlockPos targetPos, boolean callBreakEvent, int bonusToolLevel, Function<Integer, Integer> handleXP) {
        if (!BlockHelperUtil.canBreakBlock(harvestTool, world, entity, harvestedPos, targetPos, bonusToolLevel)) {
            return;
        }
        IBlockState state = world.func_180495_p(targetPos);
        Block block = state.func_177230_c();
        harvestTool.func_179548_a(world, state, targetPos, entity);
        if (!world.field_72995_K) {
            int xp = block.getExpDrop(state, (IBlockAccess)world, targetPos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)harvestTool));
            if (callBreakEvent) {
                xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)entity).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)entity), (BlockPos)targetPos);
            }
            if (handleXP != null) {
                xp = handleXP.apply(xp);
            }
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(targetPos);
            if (block.removedByPlayer(state, world, targetPos, entity, true)) {
                block.func_176206_d(world, targetPos, state);
                block.func_180657_a(world, entity, targetPos, state, tileEntity, harvestTool);
                block.func_180637_b(world, targetPos, xp);
            }
            NetworkHandler.sendPacket((Entity)entity, new SPacketBlockChange(world, targetPos));
        } else {
            world.func_175669_a(2001, targetPos, Block.func_176210_f((IBlockState)state));
            if (block.removedByPlayer(state, world, targetPos, entity, true)) {
                block.func_176206_d(world, targetPos, state);
            }
            harvestTool.func_179548_a(world, state, targetPos, entity);
            if (harvestTool.func_190916_E() == 0 && harvestTool == entity.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)entity, (ItemStack)harvestTool, (EnumHand)EnumHand.MAIN_HAND);
                entity.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, targetPos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }
}

