/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.OreDictionaryCompat;
import xzeroair.trinkets.util.helpers.StringUtils;

public class ConfigHelper {
    private static String nameRegex = "([a-zA-Z0-9_*]{1,})";
    private static String itemIDRegex = "(" + nameRegex + ":" + nameRegex + ")";
    private static String materialRegex = "(material" + nameRegex + ")";
    private static String metaRegex = "(([0-9]*)|([*]))";
    private static String metaRegexOptional = "(;" + metaRegex + ")?";
    private static String doubleRegex = "(([-])?([0-9]{1,})([.][0-9]{1,})?)";
    private static String doubleRegexOptional = "(;" + doubleRegex + ")?";
    private static String optionalWordRegex = "(;[a-zA-Z]*)?";
    private static final HashMap<String, AttributeEntry> attributeCacheMap = new HashMap();
    private static final AttributeEntry NULL_ENTRY = new AttributeEntry("null", 0.0, 0, false);

    public static String cleanConfigEntry(String config) {
        String configEntry = config.replaceAll("([\\[\\]\\|,;] ?)|(  )", " ").trim().replace(" ", ";");
        return configEntry;
    }

    public static HashMap<String, AttributeEntry> getAttributeCacheMap() {
        return attributeCacheMap;
    }

    public static void refreshAttributeCacheMap() {
        attributeCacheMap.clear();
    }

    public static AttributeEntry getAttributeEntry(String string) {
        AttributeEntry temp = ConfigHelper.getAttributeCacheMap().computeIfAbsent(string, ConfigHelper::getAttributeEntryOld);
        return temp == NULL_ENTRY ? null : temp;
    }

    public static AttributeEntry getAttributeEntryOld(String string) {
        String configEntry = ConfigHelper.cleanConfigEntry(string.replaceFirst("[nN][aA][mM][eE][:]", "").replaceFirst("[aA][mM][oO][uU][nN][tT][:]", "").replaceFirst("[oO][pP][eE][rR][aA][tT][iI][oO][nN][:]", ""));
        String[] vars = configEntry.split(";");
        String arg1 = StringUtils.getStringFromArray(vars, 0);
        String arg2 = StringUtils.getStringFromArray(vars, 1);
        String arg3 = StringUtils.getStringFromArray(vars, 2);
        String arg4 = StringUtils.getStringFromArray(vars, 3);
        String attributeRegex = "([a-zA-Z0-9_.]*)";
        String amountRegex = doubleRegex;
        String opRegex = "([0-2])";
        String boolRegex = "(true)|(false)";
        String attribute = "";
        double amount = 0.0;
        int op = 0;
        boolean saved = false;
        boolean isAttribute = false;
        if (!arg1.isEmpty() && arg1.matches(attributeRegex)) {
            attribute = arg1;
            if (!arg2.isEmpty() && arg2.matches(amountRegex)) {
                try {
                    amount = Double.parseDouble(arg2.replace("+", ""));
                    isAttribute = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!arg3.isEmpty() && arg3.matches(opRegex)) {
                    try {
                        op = Integer.parseInt(arg3);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!arg4.isEmpty() && arg4.toLowerCase().matches(boolRegex) && arg4.equalsIgnoreCase("true")) {
                    saved = true;
                }
            }
        }
        return isAttribute && !attribute.isEmpty() && amount != 0.0 ? new AttributeEntry(attribute, amount, op, saved) : NULL_ENTRY;
    }

    private static <T> T continueCommand(String string, Function<String, T> func) {
        return func.apply(string);
    }

    private static <T> T continueCommand(String arg1, String arg2, BiFunction<String, String, T> func) {
        return func.apply(arg1, arg2);
    }

    public static class ObjectPair<A, B> {
        private A first;
        private B second;

        public ObjectPair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }
    }

    public static enum EntryType {
        UNKNOWN,
        NORMAL,
        ITEM,
        BLOCK,
        ENTITY,
        MATERIAL,
        POTION,
        OREDICTIONARY;

    }

    public static class ConfigObject {
        protected String originalEntry;
        protected String modID;
        protected String objectID;
        protected int meta;
        protected String[] objectArgs;
        protected EntryType objectType;

        public ConfigObject(String modID, String objectID, int meta) {
            this(modID, objectID, meta, new String[0]);
        }

        public ConfigObject(String config) {
            this("minecraft", "air", OreDictionaryCompat.wildcard);
            this.originalEntry = config;
            this.generateConfigObject(config);
        }

        public ConfigObject(String modID, String objectID, int meta, String[] args) {
            this.originalEntry = modID + ":" + objectID + ";" + meta;
            this.modID = modID;
            this.objectID = objectID;
            this.meta = meta;
            this.objectType = EntryType.UNKNOWN;
            this.objectArgs = args;
        }

        public final String getModID() {
            return this.modID;
        }

        public final String getObjectID() {
            return this.objectID;
        }

        public final String getObjectRegistryName() {
            return this.getModID() + ":" + this.getObjectID();
        }

        public final int getMeta() {
            return this.meta;
        }

        public final EntryType getObjectType() {
            return this.objectType;
        }

        public final String[] getObjectArgs() {
            return this.objectArgs;
        }

        public final String getOriginalEntry() {
            return this.originalEntry;
        }

        public final boolean isEmpty() {
            String reg = this.getObjectRegistryName();
            boolean flag1 = reg.contentEquals("minecraft:air");
            boolean flag2 = reg.contentEquals("*:air");
            return flag1 || flag2;
        }

        protected void generateConfigObject(String configEntry) {
            String[] checkArgs = (configEntry = ConfigHelper.cleanConfigEntry(configEntry)).split(";", 2);
            String entry = StringUtils.getStringFromArray(checkArgs, 0);
            if (!entry.isEmpty()) {
                String configArgs = StringUtils.getStringFromArray(checkArgs, 1);
                boolean existsInOreDict = OreDictionaryCompat.existsInOreDictionary(entry);
                if (existsInOreDict) {
                    this.configureOreDictEntry(entry, configArgs);
                } else if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entry))) {
                    this.configureEntityEntry(entry, configArgs);
                } else if (entry.matches(itemIDRegex)) {
                    this.configureNormalEntry(entry, configArgs);
                } else if (entry.startsWith("!mat:") && !entry.replaceFirst("!mat:", "").isEmpty()) {
                    this.configureMaterialEntry(entry.replaceFirst("!mat:", "").toLowerCase(), configArgs);
                } else {
                    this.configureUnknownEntry(entry, configArgs);
                }
            }
        }

        protected void configureOreDictEntry(String entry, String configArgs) {
            this.objectType = EntryType.OREDICTIONARY;
            this.modID = "oreDict";
            this.objectID = entry;
            if (!configArgs.isEmpty()) {
                this.objectArgs = configArgs.split(";");
            }
        }

        protected void configureEntityEntry(String entry, String configArgs) {
            this.objectType = EntryType.ENTITY;
            if (entry.contains(":")) {
                String[] entryArgs = entry.split(":");
                String mod = StringUtils.getStringFromArray(entryArgs, 0);
                String entity = StringUtils.getStringFromArray(entryArgs, 1);
                if (!mod.isEmpty()) {
                    this.modID = mod;
                }
                if (!entity.isEmpty()) {
                    this.objectID = entity;
                }
            } else {
                this.objectID = entry;
            }
            if (!configArgs.isEmpty()) {
                this.objectArgs = configArgs.split(";");
            }
        }

        protected void configureMaterialEntry(String entry, String configArgs) {
            this.objectType = EntryType.MATERIAL;
            this.modID = "ObjectMaterial";
            this.objectID = entry;
            if (!configArgs.isEmpty()) {
                this.objectArgs = configArgs.split(";");
            }
        }

        protected void configureNormalEntry(String entry, String configArgs) {
            this.objectType = EntryType.NORMAL;
            String[] itemArgs = entry.split(":");
            String mod = StringUtils.getStringFromArray(itemArgs, 0);
            String item = StringUtils.getStringFromArray(itemArgs, 1);
            if (!mod.isEmpty()) {
                this.modID = mod;
            }
            if (!item.isEmpty()) {
                this.objectID = item;
            }
            if (mod.equalsIgnoreCase("minecraft") && item.equalsIgnoreCase("potion")) {
                this.objectType = EntryType.POTION;
                if (!configArgs.isEmpty()) {
                    this.objectArgs = configArgs.split(";");
                }
            } else {
                String[] args = configArgs.split(";", 2);
                String Meta = StringUtils.getStringFromArray(args, 0);
                if (!Meta.isEmpty()) {
                    String leftoverArgs;
                    int index = 1;
                    if (!Meta.contentEquals("*")) {
                        if (Meta.matches("([0-9]{1,})")) {
                            try {
                                this.meta = Math.min(Math.max(Integer.parseInt(Meta), 0), OreDictionaryCompat.wildcard);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            index = 0;
                        }
                    }
                    if (!(leftoverArgs = StringUtils.getStringFromArray(args, index)).isEmpty()) {
                        this.objectArgs = leftoverArgs.split(";");
                    }
                }
            }
        }

        protected void configureUnknownEntry(String entry, String configArgs) {
            this.objectType = EntryType.UNKNOWN;
            this.modID = "unknown";
            this.objectID = entry;
            if (!configArgs.isEmpty()) {
                this.objectArgs = configArgs.split(";");
            }
        }

        public boolean doesItemMatchEntry(@Nonnull ItemStack stack) {
            if (stack == null || stack.func_190926_b() || this.isEmpty()) {
                return false;
            }
            EntryType type = this.getObjectType();
            switch (type) {
                case OREDICTIONARY: {
                    return this.doesOreDictMatch(stack);
                }
                case MATERIAL: {
                    return this.doesMaterialMatch(stack);
                }
                case POTION: {
                    return this.doesPotionMatch(stack);
                }
            }
            return this.doesItemMatch(stack);
        }

        protected boolean doesPotionMatch(@Nonnull ItemStack stack) {
            return this.doesItemMatch(stack);
        }

        protected boolean doesItemMatch(@Nonnull ItemStack stack) {
            String mod = stack.func_77973_b().getRegistryName().func_110624_b();
            String item = stack.func_77973_b().getRegistryName().func_110623_a();
            if (this.modID.contentEquals("*") || this.modID.contentEquals(mod)) {
                boolean metaMatches;
                boolean bl = metaMatches = this.meta == OreDictionaryCompat.wildcard || stack.func_77960_j() == this.meta;
                if (this.objectID.contentEquals(item) && metaMatches) {
                    return true;
                }
                String objectEntry = this.objectID.replace("*", "");
                boolean startWildcard = this.objectID.startsWith("*");
                boolean endWildcard = this.objectID.endsWith("*");
                if (startWildcard && endWildcard ? item.contains(objectEntry) && metaMatches : (endWildcard ? item.startsWith(objectEntry) && metaMatches : startWildcard && item.endsWith(objectEntry) && metaMatches)) {
                    return true;
                }
            }
            return false;
        }

        protected boolean doesOreDictMatch(@Nonnull ItemStack stack) {
            for (String oreDictionary : OreDictionaryCompat.getOreNames(stack)) {
                if (!oreDictionary.equalsIgnoreCase(this.objectID)) continue;
                return true;
            }
            return false;
        }

        protected boolean doesMaterialMatch(@Nonnull ItemStack stack) {
            String[] checkForType = this.objectID.split(":");
            String mat = StringUtils.getStringFromArray(checkForType, 0);
            String ItemMaterial = ArmorEntry.getItemMaterial(stack).toLowerCase();
            return !ItemMaterial.isEmpty() && mat.equalsIgnoreCase(ItemMaterial);
        }

        public boolean doesBlockMatchEntry(@Nonnull IBlockState state) {
            if (state == null || this.isEmpty()) {
                return false;
            }
            ItemStack blockStack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            return this.doesItemMatchEntry(blockStack);
        }
    }

    public static class AttributeEntry {
        private String attribute;
        private double amount;
        private int operation;
        private boolean isSaved;

        public AttributeEntry(String attribute, double amount, int operation, boolean isSaved) {
            this.attribute = attribute;
            this.amount = amount;
            this.operation = operation;
            this.isSaved = isSaved;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public double getAmount() {
            return this.amount;
        }

        public int getOperation() {
            return this.operation;
        }

        public boolean isSaved() {
            return this.isSaved;
        }

        public String toString() {
            return "AttributeEntry [attribute=" + this.attribute + ", amount=" + this.amount + ", operation=" + this.operation + ", isSaved=" + this.isSaved + "]";
        }
    }

    public static class PotionEntry
    extends ConfigObject {
        protected Potion potion;
        protected PotionEffect effect;
        protected int duration;
        protected int amplifier;

        public PotionEntry(String ConfigEntry) {
            super(ConfigEntry);
        }

        @Override
        public boolean doesItemMatchEntry(ItemStack stack) {
            if (stack == null || stack.func_190926_b() || this.isEmpty()) {
                return false;
            }
            return super.doesItemMatchEntry(stack);
        }
    }

    public static class ArmorEntry
    extends ConfigObject {
        public static final Set<String> validHandTypes = new HashSet<String>(Arrays.asList("mainhand", "offhand"));
        public static final Set<String> validArmorTypes = new HashSet<String>(Arrays.asList("feet", "legs", "chest", "head"));
        public static final Set<String> validEquipmentTypes = new HashSet<String>(Arrays.asList("feet", "legs", "chest", "head", "mainhand", "offhand"));
        public static final Set<String> validArmsTypes = new HashSet<String>(Arrays.asList("sword", "shield", "axe", "pickaxe", "shovel", "hoe"));
        public static final Set<String> validToolTypes = new HashSet<String>(Arrays.asList("axe", "pickaxe", "shovel", "hoe", "shears"));
        protected double equipmentWeight;
        protected String slotType;
        protected String equipmentType;

        public ArmorEntry(String configEntry) {
            super(configEntry);
        }

        @Override
        protected void generateConfigObject(String configEntry) {
            this.slotType = "";
            this.equipmentType = "";
            configEntry.replaceAll("([\\[\\]\\|,;] ?)", ";").trim();
            String[] checkArgs = configEntry.split(";", 2);
            String entry = StringUtils.getStringFromArray(checkArgs, 0);
            if (!entry.isEmpty()) {
                String configArgs = StringUtils.getStringFromArray(checkArgs, 1);
                if (entry.matches(itemIDRegex)) {
                    this.configureNormalEntry(entry, configArgs);
                } else {
                    this.configureMaterialEntry(entry.toLowerCase(), configArgs);
                }
            }
        }

        @Override
        public boolean doesItemMatchEntry(ItemStack stack) {
            boolean matches = super.doesItemMatchEntry(stack);
            if (matches) {
                Item item = stack.func_77973_b();
                String t = this.getEquipmentType();
                String s = this.getEquipmentSlot();
                String itemType = ArmorEntry.getItemType(stack).toLowerCase();
                boolean typeMatch = t.isEmpty() ? true : (t.equals("tool") ? item instanceof ItemTool || !ArmorEntry.isValidTools(itemType).isEmpty() : (t.equals("armor") ? item instanceof ItemArmor || !ArmorEntry.isValidArmor(itemType).isEmpty() : t.equals(itemType)));
                boolean slotMatch = s.isEmpty() ? true : ArmorEntry.isValidArmor(itemType).isEmpty();
                String regName = item.getRegistryName().toString();
                boolean regMatch = this.getObjectRegistryName().contentEquals(regName);
                if (regMatch && typeMatch && slotMatch) {
                    return true;
                }
                return typeMatch && slotMatch;
            }
            return matches;
        }

        @Override
        protected boolean doesMaterialMatch(ItemStack stack) {
            return super.doesMaterialMatch(stack);
        }

        @Override
        protected void configureNormalEntry(String entry, String configArgs) {
            super.configureNormalEntry(entry, configArgs);
            int index = 0;
            if (!this.addEquipmentWeight(StringUtils.getStringFromArray(this.getObjectArgs(), index))) {
                if (this.addEquipmentSlot(StringUtils.getStringFromArray(this.getObjectArgs(), index))) {
                    ++index;
                }
                if (this.addArmType(StringUtils.getStringFromArray(this.getObjectArgs(), index))) {
                    ++index;
                }
                this.addEquipmentWeight(StringUtils.getStringFromArray(this.getObjectArgs(), index));
            }
        }

        @Override
        protected void configureMaterialEntry(String entry, String configArgs) {
            super.configureMaterialEntry(entry, configArgs);
            int index = 0;
            if (!this.addEquipmentWeight(StringUtils.getStringFromArray(this.getObjectArgs(), index))) {
                if (this.addEquipmentSlot(StringUtils.getStringFromArray(this.getObjectArgs(), index))) {
                    ++index;
                }
                if (this.addArmType(StringUtils.getStringFromArray(this.getObjectArgs(), index))) {
                    ++index;
                }
                this.addEquipmentWeight(StringUtils.getStringFromArray(this.getObjectArgs(), index));
            }
        }

        private boolean addArmType(String entry) {
            String toolType = ArmorEntry.isValidArms(entry);
            if (!toolType.isEmpty() || entry.equals("tool")) {
                this.equipmentType = entry;
                return true;
            }
            this.equipmentType = "";
            return false;
        }

        private boolean addEquipmentSlot(String entry) {
            String slotType = ArmorEntry.isValidEquipmentSlot(this.fixArmorType(entry));
            if (!slotType.isEmpty() || entry.equals("armor") || entry.equals("hand")) {
                this.slotType = entry;
                return true;
            }
            this.slotType = "";
            return false;
        }

        private boolean addEquipmentWeight(String entry) {
            if (!entry.isEmpty() && entry.matches(doubleRegex)) {
                try {
                    this.equipmentWeight = Double.parseDouble(entry);
                    return true;
                }
                catch (Exception e) {
                    Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                    e.printStackTrace();
                }
            }
            this.equipmentWeight = 0.0;
            return false;
        }

        protected String fixArmorType(String string) {
            return string.replace("boot", "feet").replace("boots", "feet").replace("feets", "feet").replace("leggings", "legs").replace("pants", "legs").replace("chestplate", "chest").replace("shirt", "chest").replace("helm", "head").replace("hat", "head");
        }

        public static String getItemMaterial(@Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return "";
            }
            Item item = stack.func_77973_b();
            if (item instanceof ItemArmor) {
                ItemArmor armor = (ItemArmor)item;
                return armor.func_82812_d().toString();
            }
            if (item instanceof ItemSword) {
                ItemSword sword = (ItemSword)item;
                return sword.func_150932_j();
            }
            if (item instanceof ItemTool) {
                ItemTool tool = (ItemTool)item;
                return tool.func_77861_e();
            }
            if (item instanceof ItemHoe) {
                ItemHoe hoe = (ItemHoe)item;
                return hoe.func_77842_f();
            }
            return "";
        }

        public static String getItemType(@Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return "";
            }
            Item item = stack.func_77973_b();
            if (item instanceof ItemArmor) {
                return ((ItemArmor)item).field_77881_a.func_188450_d();
            }
            if (item instanceof ItemSword) {
                return "sword";
            }
            if (item instanceof ItemBow) {
                return "bow";
            }
            if (item instanceof ItemShield) {
                return "shield";
            }
            if (item instanceof ItemAxe) {
                return "axe";
            }
            if (item instanceof ItemPickaxe) {
                return "pickaxe";
            }
            if (item instanceof ItemSpade) {
                return "shovel";
            }
            if (item instanceof ItemHoe) {
                return "hoe";
            }
            if (item instanceof ItemShears) {
                return "shears";
            }
            if (item instanceof ItemTool) {
                return "tool";
            }
            return "";
        }

        public static String isValidEquipmentSlot(String input) {
            if (!input.isEmpty() && validEquipmentTypes.contains(input)) {
                return input;
            }
            return "";
        }

        public static String isValidArms(String input) {
            if (!input.isEmpty() && validArmsTypes.contains(input)) {
                return input;
            }
            return "";
        }

        public static String isValidTools(String input) {
            if (!input.isEmpty() && validToolTypes.contains(input)) {
                return input;
            }
            return "";
        }

        public static String isValidArmor(String input) {
            if (!input.isEmpty() && validArmorTypes.contains(input)) {
                return input;
            }
            return "";
        }

        public static String isValidHand(String input) {
            if (!input.isEmpty() && validHandTypes.contains(input)) {
                return input;
            }
            return "";
        }

        public String getEquipmentSlot() {
            return this.slotType;
        }

        public String getEquipmentType() {
            return this.equipmentType;
        }

        public double getEquipmentWeight() {
            return this.equipmentWeight;
        }
    }

    public static class MPRecoveryItem
    extends ConfigObject {
        protected float amount;
        protected boolean multiplied;

        public MPRecoveryItem(String configEntry) {
            super(configEntry);
            this.initValues(this.getObjectArgs());
        }

        private void initValues(String[] args) {
            String Amount = StringUtils.getStringFromArray(args, 0);
            if (!Amount.isEmpty()) {
                if (Amount.endsWith("%")) {
                    this.multiplied = true;
                }
                Amount = Amount.replace("%", "");
                try {
                    this.amount = Float.parseFloat(Amount);
                }
                catch (Exception e) {
                    Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                    e.printStackTrace();
                    this.amount = 0.0f;
                }
            }
        }

        public final float getAmount() {
            return this.amount;
        }

        public final boolean isMultiplied() {
            return this.multiplied;
        }
    }

    public static class TreasureEntry
    extends ConfigObject {
        protected int color = 16766720;

        public TreasureEntry(String configEntry) {
            super(configEntry);
            this.initValues(this.getObjectArgs());
        }

        private void initValues(String[] args) {
            String Color = StringUtils.getStringFromArray(args, 0);
            if (!Color.isEmpty()) {
                try {
                    this.color = Integer.parseInt(Color.replace("*", OreDictionaryCompat.wildcard + ""));
                }
                catch (Exception e) {
                    Trinkets.log.error("Invalid format for entry: " + this.getOriginalEntry());
                    e.printStackTrace();
                    this.color = 16766720;
                }
            }
        }

        public final int getColor() {
            return this.color;
        }
    }

    public static class TrinketConfigStorage {
        public static TreeMap<String, MPRecoveryItem> MagicRecoveryItems = new TreeMap();
        public static TreeMap<Integer, TreasureEntry> TreasureBlocks = new TreeMap();
        public static LinkedHashMap<String, ConfigObject> ClimbableBlocks = new LinkedHashMap();
        public static LinkedHashMap<String, ArmorEntry> ArmorWeightValues = new LinkedHashMap();

        public static void init() {
            TrinketConfigStorage.initRecoveryItems();
            TrinketConfigStorage.initArmorWeightValues();
            TrinketConfigStorage.initTreasureBlocks();
        }

        private static void initTreasureBlocks() {
            if (!TreasureBlocks.isEmpty()) {
                TreasureBlocks.clear();
            }
            String[] treasures = TrinketsConfig.SERVER.Items.DRAGON_EYE.BLOCKS.Blocks;
            int index = 0;
            for (String entry : treasures) {
                TreasureEntry treasure = new TreasureEntry(entry);
                if (treasure.isEmpty()) continue;
                TreasureBlocks.put(index, treasure);
                ++index;
            }
        }

        public static ArmorEntry getEquipmentEntry(String ... strings) {
            return TrinketConfigStorage.getEquipmentEntry((Predicate<ArmorEntry>)null, strings);
        }

        public static ArmorEntry getEquipmentEntry(Predicate<ArmorEntry> predicate, String ... strings) {
            return TrinketConfigStorage.getListEntry(ArmorWeightValues, predicate, strings);
        }

        public static ArmorEntry getEquipmentEntry(BiPredicate<String, ArmorEntry> predicate, String ... strings) {
            return TrinketConfigStorage.getListEntry(ArmorWeightValues, predicate, strings);
        }

        public static <v, s> v getListEntry(Map<s, v> map, BiPredicate<s, v> predicate, s ... keys) {
            for (s s : keys) {
                v e = map.get(s);
                if (e == null) continue;
                if (predicate != null) {
                    if (!predicate.test(s, e)) continue;
                    return e;
                }
                return e;
            }
            if (predicate != null && keys.length <= 0) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!predicate.test(entry.getKey(), entry.getValue())) continue;
                    return (v)entry.getValue();
                }
            }
            return null;
        }

        public static <v, s> v getListEntry(Map<s, v> map, Predicate<v> predicate, s ... keys) {
            for (s s : keys) {
                v e = map.get(s);
                if (e == null) continue;
                if (predicate != null) {
                    if (!predicate.test(e)) continue;
                    return e;
                }
                return e;
            }
            if (predicate != null && keys.length <= 0) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!predicate.test(entry.getValue())) continue;
                    return (v)entry.getValue();
                }
            }
            return null;
        }

        private static void initArmorWeightValues() {
            String[] weightValues;
            if (!ArmorWeightValues.isEmpty()) {
                ArmorWeightValues.clear();
            }
            for (String entry : weightValues = TrinketsConfig.SERVER.races.faelis.heavyArmor) {
                ArmorEntry weightValue = new ArmorEntry(entry);
                if (weightValue.isEmpty()) continue;
                String equipSlot = weightValue.getEquipmentSlot();
                String toolType = weightValue.getEquipmentType();
                ArmorWeightValues.put(weightValue.getObjectRegistryName() + (equipSlot.isEmpty() ? "" : ":" + equipSlot) + (toolType.isEmpty() ? "" : ":" + toolType), weightValue);
            }
        }

        private static void initRecoveryItems() {
            String[] recovery;
            if (!MagicRecoveryItems.isEmpty()) {
                MagicRecoveryItems.clear();
            }
            for (String entry : recovery = TrinketsConfig.SERVER.mana.recovery) {
                MPRecoveryItem recoveryItem = new MPRecoveryItem(entry);
                if (recoveryItem.isEmpty()) continue;
                MagicRecoveryItems.put(recoveryItem.getObjectRegistryName(), recoveryItem);
            }
        }
    }
}

