/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.util.compat.baubles;

import baubles.api.BaubleType;
import baubles.api.cap.BaublesCapabilities;
import baubles.api.cap.IBaublesItemHandler;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import xzeroair.trinkets.capabilities.Capabilities;

public class BaublesHelper {
    public static IBaublesItemHandler getBaublesHandler(EntityLivingBase entity) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, BaublesCapabilities.CAPABILITY_BAUBLES, handler -> handler.setPlayer(entity));
    }

    public static IBaublesItemHandler getBaublesHandler(EntityLivingBase entity, Consumer<IBaublesItemHandler> consumer) {
        return Capabilities.getCapabilityWithConsumer((ICapabilitySerializable)entity, BaublesCapabilities.CAPABILITY_BAUBLES, handler -> {
            handler.setPlayer(entity);
            consumer.accept((IBaublesItemHandler)handler);
        });
    }

    public static <R> R getBaublesHandler(EntityLivingBase entity, R ret, BiFunction<IBaublesItemHandler, R, R> func) {
        return (R)Capabilities.getCapabilityWithReturn((ICapabilitySerializable)entity, BaublesCapabilities.CAPABILITY_BAUBLES, ret, (handler, rtn) -> {
            handler.setPlayer(entity);
            return func.apply((IBaublesItemHandler)handler, (Object)rtn);
        });
    }

    public static BaubleType getBaubleType(String string) {
        if ((string = string.toLowerCase()).contentEquals("amulet") || string.contentEquals("necklace") || string.contentEquals("pendant")) {
            return BaubleType.AMULET;
        }
        if (string.contentEquals("ring") || string.contentEquals("rings")) {
            return BaubleType.RING;
        }
        if (string.contentEquals("belt")) {
            return BaubleType.BELT;
        }
        if (string.contentEquals("head") || string.contentEquals("hat")) {
            return BaubleType.HEAD;
        }
        if (string.contentEquals("body") || string.contentEquals("chest")) {
            return BaubleType.BODY;
        }
        if (string.contentEquals("charm")) {
            return BaubleType.CHARM;
        }
        return BaubleType.TRINKET;
    }
}

