/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigWitherRing;

public class AbilityWitherAffinity
extends Ability
implements IAttackAbility,
IPotionAbility {
    private static final ConfigWitherRing serverConfig = TrinketsConfig.SERVER.Items.WITHER_RING;

    public AbilityWitherAffinity() {
        super("wither_immunity");
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource source, float dmg, boolean cancel) {
        if (source.equals(DamageSource.field_82727_n)) {
            return true;
        }
        return cancel;
    }

    @Override
    public boolean attackEntity(EntityLivingBase target, DamageSource source, float dmg, boolean cancel) {
        Random rand;
        if (AbilityWitherAffinity.serverConfig.wither && !target.func_70644_a(MobEffects.field_82731_v) && (rand = new Random()).nextInt(AbilityWitherAffinity.serverConfig.wither_chance) == 0) {
            target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, AbilityWitherAffinity.serverConfig.wither_duration, 0, false, true));
        }
        return cancel;
    }

    @Override
    public float damageEntity(EntityLivingBase target, DamageSource source, float dmg) {
        if (AbilityWitherAffinity.serverConfig.leech && target.func_70644_a(MobEffects.field_82731_v) && AbilityWitherAffinity.serverConfig.leech_amount > 0.0f) {
            if (dmg >= AbilityWitherAffinity.serverConfig.leech_amount) {
                ((EntityLivingBase)source.func_76346_g()).func_70691_i(AbilityWitherAffinity.serverConfig.leech_amount);
            } else {
                ((EntityLivingBase)source.func_76346_g()).func_70691_i(dmg);
            }
        }
        return dmg;
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        String e = effect.func_188419_a().getRegistryName().toString();
        for (String immunity : TrinketsConfig.SERVER.Items.WITHER_RING.immunities) {
            Potion pot = Potion.func_180142_b((String)immunity);
            if (pot == null || !e.contentEquals(pot.getRegistryName().toString())) continue;
            return true;
        }
        return cancel;
    }
}

