/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.Vip.VipStatus;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.config.ClientConfig;
import xzeroair.trinkets.util.config.trinkets.ConfigDamageShield;

public class AbilityResistance
extends Ability
implements ITickableAbility,
IAttackAbility,
IPotionAbility {
    protected static final ClientConfig.ClientConfigItems.ClientConfigDamageShield clientConfig = TrinketsConfig.CLIENT.items.DAMAGE_SHIELD;
    protected static final ConfigDamageShield serverConfig = TrinketsConfig.SERVER.Items.DAMAGE_SHIELD;
    protected int hitCount = 0;

    public AbilityResistance() {
        super("safe_guard");
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public AbilityResistance setHitCount(int hitCount) {
        this.hitCount = hitCount;
        return this;
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        boolean has;
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        int duration = 200;
        Potion resistance = Potion.func_180142_b((String)AbilityResistance.serverConfig.potionEffect);
        if (resistance == null) {
            resistance = MobEffects.field_76429_m;
        }
        if (!(has = entity.func_70644_a(resistance))) {
            entity.func_70690_d(new PotionEffect(resistance, 200, AbilityResistance.serverConfig.resistance_level, false, false));
        }
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource source, float dmg, boolean cancel) {
        boolean indirect;
        if (AbilityResistance.serverConfig.damage_ignore && !attacked.field_70170_p.field_72995_K && dmg >= 1.0f && (indirect = this.isIndirectDamage(source))) {
            this.countHit(attacked, indirect);
            if (this.trigger(attacked, indirect)) {
                return true;
            }
        }
        return cancel;
    }

    @Override
    public float hurt(EntityLivingBase attacked, DamageSource source, float dmg) {
        boolean indirect;
        if (AbilityResistance.serverConfig.damage_ignore && dmg >= 1.0f && !(indirect = this.isIndirectDamage(source))) {
            this.countHit(attacked, indirect);
            if (this.trigger(attacked, indirect)) {
                dmg = 0.0f;
            }
        }
        if (AbilityResistance.serverConfig.explosion_resist && source.func_94541_c() && dmg >= 1.0f) {
            return dmg * AbilityResistance.serverConfig.explosion_amount;
        }
        return dmg;
    }

    protected void countHit(EntityLivingBase attacked, boolean indirect) {
        ++this.hitCount;
        Capabilities.getEntityProperties((Entity)attacked, prop -> prop.sendInformationToPlayer(attacked));
    }

    protected boolean trigger(EntityLivingBase attacked, boolean indirect) {
        if (this.hitCount > AbilityResistance.serverConfig.hits) {
            this.hitCount = 0;
            if (attacked instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)attacked;
                if (AbilityResistance.serverConfig.special && TrinketsConfig.SERVER.misc.retrieveVIP) {
                    String quote;
                    String string = "Ow!";
                    VipStatus vip = Capabilities.getVipStatus((Entity)attacked);
                    if (vip != null && !(quote = vip.getRandomQuote()).isEmpty()) {
                        string = quote;
                    }
                    TextComponentString message = new TextComponentString(TextFormatting.BOLD + "" + TextFormatting.GOLD + string);
                    player.func_146105_b((ITextComponent)message, true);
                    if (AbilityResistance.clientConfig.effectVolume > 0.0) {
                        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187692_g, SoundCategory.PLAYERS, (float)AbilityResistance.clientConfig.effectVolume, 1.0f);
                    }
                }
            }
            Capabilities.getEntityProperties((Entity)attacked, prop -> prop.sendInformationToPlayer(attacked));
            return true;
        }
        return false;
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        String targetEffect;
        String AppliedEffect = effect.func_188419_a().getRegistryName().toString();
        if (!AppliedEffect.contentEquals(targetEffect = AbilityResistance.serverConfig.potionEffect)) {
            return cancel;
        }
        if (!entity.field_70170_p.field_72995_K && AbilityResistance.serverConfig.resistance_stacks) {
            Potion resistance = Potion.func_180142_b((String)targetEffect);
            if (resistance == null) {
                resistance = MobEffects.field_76429_m;
            }
            boolean has = entity.func_70644_a(resistance);
            PotionEffect newEffect = effect;
            int newAmp = newEffect.func_76458_c();
            int newDur = newEffect.func_76459_b();
            if (!has) {
                return cancel;
            }
            PotionEffect oldEffect = entity.func_70660_b(resistance);
            int oldAmp = oldEffect.func_76458_c();
            int oldDur = oldEffect.func_76459_b();
            int amp = newAmp + 1;
            int duration = newDur;
            if (oldAmp > amp) {
                return true;
            }
            if (amp <= AbilityResistance.serverConfig.resistance_stacks_max) {
                try {
                    PotionEffect e = new PotionEffect(resistance, duration, amp, false, false);
                    effect.func_76452_a(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return cancel;
    }

    @Override
    public void onAbilityRemoved(EntityLivingBase entity) {
        Potion resistance = Potion.func_180142_b((String)AbilityResistance.serverConfig.potionEffect);
        if (resistance == null) {
            resistance = MobEffects.field_76429_m;
        }
        if (entity.func_70644_a(resistance)) {
            entity.func_184589_d(resistance);
            if (entity.field_70170_p.field_72995_K) {
                entity.func_70690_d(new PotionEffect(resistance, 30, AbilityResistance.serverConfig.resistance_level, false, false));
            }
        }
    }

    @Override
    public void loadStorage(NBTTagCompound compound) {
        if (compound.func_74764_b("hitCount")) {
            this.hitCount = compound.func_74762_e("hitCount");
        }
    }

    @Override
    public NBTTagCompound saveStorage(NBTTagCompound compound) {
        compound.func_74768_a("hitCount", this.hitCount);
        return compound;
    }
}

