/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.init.ModPotionTypes;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IAttackAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ILightningStrikeAbility;
import xzeroair.trinkets.traits.abilities.interfaces.IPotionAbility;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.iceandfire.IceAndFireCompat;
import xzeroair.trinkets.util.compat.lycanitesmobs.LycanitesCompat;
import xzeroair.trinkets.util.config.trinkets.ConfigDragonsEye;

public class AbilityLightningImmunity
extends Ability
implements ITickableAbility,
IPotionAbility,
IAttackAbility,
ILightningStrikeAbility {
    public static ConfigDragonsEye serverConfig = TrinketsConfig.SERVER.Items.DRAGON_EYE;
    Potion lightning_resist = ModPotionTypes.TrinketPotions.get("lightning_resistance");

    public AbilityLightningImmunity() {
        super("lightning_immunity");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        AbilityHandler.AbilityHolder holder = this.getAbilityHolder();
        if (holder.getInfo().getHandlerType() == TrinketHelper.SlotInformation.ItemHandlerType.POTION) {
            return;
        }
        if (this.lightning_resist != null) {
            if (!entity.func_70644_a(this.lightning_resist)) {
                entity.func_70690_d(new PotionEffect(this.lightning_resist, 400, 0, false, false));
            }
            if (entity.field_70170_p.field_72995_K && entity.func_70644_a(this.lightning_resist)) {
                entity.func_70660_b(this.lightning_resist).func_100012_b(true);
            }
        }
    }

    @Override
    public boolean potionApplied(EntityLivingBase entity, PotionEffect effect, boolean cancel) {
        if (!AbilityLightningImmunity.serverConfig.compat.iaf.PARALYSIS_IMMUNITY) {
            return cancel;
        }
        String e = effect.func_188419_a().getRegistryName().toString();
        Potion lycanitesParalysis = LycanitesCompat.getPotionEffectByName("paralysis");
        if (lycanitesParalysis != null && e.contentEquals(lycanitesParalysis.getRegistryName().toString())) {
            return true;
        }
        Potion iceAndFireParalysis = IceAndFireCompat.getPotionEffectByName("paralysis");
        if (iceAndFireParalysis != null && e.contentEquals(iceAndFireParalysis.getRegistryName().toString())) {
            return true;
        }
        return cancel;
    }

    @Override
    public boolean attacked(EntityLivingBase attacked, DamageSource source, float dmg, boolean cancel) {
        if (source.field_76373_n.contentEquals(DamageSource.field_180137_b.field_76373_n) || source.field_76373_n.contentEquals("dragon_lightning") || source.field_76373_n.contentEquals("locks.shock")) {
            return true;
        }
        return cancel;
    }

    @Override
    public void onAbilityRemoved(EntityLivingBase entity) {
        if (this.lightning_resist != null) {
            entity.func_184589_d(this.lightning_resist);
        }
    }

    @Override
    public boolean onStruckByLightning(EntityLivingBase entity, boolean cancel) {
        entity.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 20, 1));
        return true;
    }
}

